/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.ArrayList;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class EventListenersTest
extends JbpmTestCase {
    private static final String PROCESS = "org/jbpm/test/functional/EventListeners.bpmn";
    private static final String PROCESS_ID = "org.jbpm.test.functional.EventListeners";
    private KieSession ksession;

    public EventListenersTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ksession = this.createKSession(PROCESS);
    }

    @Test(timeout=60000L)
    public void testClearExecution() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        commands.add(EventListenersTest.getCommands().newSignalEvent("other-branch", (Object)"hello world!"));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        Assert.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        Assert.assertFalse((boolean)listener.wasNodeTriggered("script-warning"));
        Assert.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        Assert.assertFalse((boolean)listener.wasNodeLeft("script-warning"));
        Assert.assertTrue((boolean)listener.wasVariableChanged("signalData"));
        Assert.assertFalse((boolean)listener.wasVariableChanged("stringVariable"));
        Assert.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }

    @Test(timeout=60000L)
    public void testUnfinishedProcess() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        Assert.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        Assert.assertTrue((boolean)listener.wasNodeTriggered("split"));
        Assert.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        Assert.assertFalse((boolean)listener.wasNodeLeft("xor-gateway"));
        Assert.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        Assert.assertFalse((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }

    @Test(timeout=60000L)
    public void testBadSignal() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        commands.add(EventListenersTest.getCommands().newSignalEvent("bad-signal", (Object)"bad signal!"));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        Assert.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        Assert.assertFalse((boolean)listener.wasNodeTriggered("info"));
        Assert.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        Assert.assertFalse((boolean)listener.wasNodeLeft("info"));
        Assert.assertFalse((boolean)listener.wasVariableChanged("signalData"));
        Assert.assertFalse((boolean)listener.wasVariableChanged("stringVariable"));
        Assert.assertTrue((boolean)listener.wasNodeLeft("script-warning"));
        Assert.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        Assert.assertTrue((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }
}

