/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.commands.ExecuteSQLQueryCommand;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.jbpm.test.listener.CountDownAsyncJobListener;
import org.junit.Test;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.RequestInfo;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.executor.api.CommandContext;

public class ExecuteSQLQueryCommandTest
extends JbpmAsyncJobTestCase {
    private static final String HELLO_WORLD = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    private static final String HELLO_WORLD_ID = "org.jbpm.test.functional.common.HelloWorldProcess1";
    private static final String PU_NAME = "org.jbpm.persistence.complete";
    private static final String SQL = "select * from ProcessInstanceLog plog where plog.processId=:processId";
    private EntityManagerFactory emf = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.emf = EntityManagerFactoryManager.get().getOrCreate(PU_NAME);
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.emf != null) {
                this.emf.close();
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Test(timeout=10000L)
    public void testScheduleSQLQueryCommand() {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        KieSession kieSession = this.createKSession(HELLO_WORLD);
        this.startProcess(kieSession, HELLO_WORLD_ID, 1);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", HELLO_WORLD_ID);
        CommandContext commandContext = this.setSQLQueryCommand(SQL, params);
        this.getExecutorService().scheduleRequest(ExecuteSQLQueryCommand.class.getName(), (org.kie.api.executor.CommandContext)commandContext);
        countDownListener.waitTillCompleted();
        List requests = this.getExecutorService().getAllRequests((QueryContext)new org.kie.internal.query.QueryContext());
        Assertions.assertThat((List)requests).isNotNull();
        Assertions.assertThat((int)requests.size()).isEqualTo(1);
        Assertions.assertThat((String)((RequestInfo)requests.get(0)).getCommandName()).isEqualTo(ExecuteSQLQueryCommand.class.getName());
    }

    @Test(timeout=10000L)
    public void testSQLQueryCommandResults() throws Exception {
        KieSession kieSession = this.createKSession(HELLO_WORLD);
        this.startProcess(kieSession, HELLO_WORLD_ID, 1);
        Query query = this.emf.createEntityManager().createNativeQuery(SQL);
        query.setParameter("processId", (Object)HELLO_WORLD_ID);
        Assertions.assertThat((List)query.getResultList()).isNotNull();
        Assertions.assertThat((int)query.getResultList().size()).isEqualTo(1);
        ExecuteSQLQueryCommand command = new ExecuteSQLQueryCommand();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", HELLO_WORLD_ID);
        ExecutionResults results = command.execute((org.kie.api.executor.CommandContext)this.setSQLQueryCommand(SQL, params));
        Assertions.assertThat((Object)results.getData("data")).isNotNull();
        Assertions.assertThat((Object)results.getData("size")).isEqualTo((Object)1);
    }

    private CommandContext setSQLQueryCommand(String sql, Map<String, Object> parameters) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)PU_NAME);
        commandContext.setData("SQL", (Object)sql);
        StringBuilder sb = new StringBuilder();
        parameters.forEach((key, value) -> {
            sb.append((String)key).append(",");
            commandContext.setData(key, value);
        });
        commandContext.setData("ParametersList", (Object)sb.toString());
        commandContext.setData("SingleRun", (Object)"true");
        return commandContext;
    }
}

