/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.junit.Assert;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

class HumanTaskResolver
implements Runnable {
    private final long pid;
    private final RuntimeManager runtime;
    private CountDownLatch latch;

    public HumanTaskResolver(long pid, RuntimeManager runtime, CountDownLatch latch) {
        this.pid = pid;
        this.runtime = runtime;
        this.latch = latch;
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>" + pid);
    }

    @Override
    public void run() {
        System.out.println(this.pid + " running tasks");
        TaskService taskService1 = this.getTaskService();
        List tasks1 = taskService1.getTasksAssignedAsPotentialOwner("sales", "en-UK");
        TaskSummary task1 = this.selectTaskForProcessInstance(tasks1);
        System.out.println("Sales-rep executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
        taskService1.claim(task1.getId().longValue(), "sales-rep");
        taskService1.start(task1.getId().longValue(), "sales-rep");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("comment", "Agreed, existing laptop needs replacing");
        results.put("outcome", "Accept");
        taskService1.complete(task1.getId().longValue(), "sales-rep", results);
        TaskService taskService2 = this.getTaskService();
        List tasks2 = taskService2.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        TaskSummary task2 = this.selectTaskForProcessInstance(tasks2);
        System.out.println("krisv executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
        taskService2.start(task2.getId().longValue(), "krisv");
        results = new HashMap();
        results.put("outcome", "Agree");
        taskService2.complete(task2.getId().longValue(), "krisv", results);
        TaskService taskService3 = this.getTaskService();
        List tasks3 = taskService3.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task3 = this.selectTaskForProcessInstance(tasks3);
        System.out.println("john executing task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ")");
        taskService3.claim(task3.getId().longValue(), "john");
        taskService3.start(task3.getId().longValue(), "john");
        results = new HashMap();
        results.put("outcome", "Agree");
        taskService3.complete(task3.getId().longValue(), "john", results);
        TaskService taskService4 = this.getTaskService();
        List tasks4 = taskService4.getTasksAssignedAsPotentialOwner("sales-rep", "en-UK");
        TaskSummary task4 = this.selectTaskForProcessInstance(tasks4);
        System.out.println("sales-rep executing task " + task4.getName() + "(" + task4.getId() + ": " + task4.getDescription() + ")");
        taskService4.start(task4.getId().longValue(), "sales-rep");
        Task task = taskService4.getTaskById(task4.getId().longValue());
        Content content = taskService4.getContentById(task.getTaskData().getDocumentContentId());
        Object result = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        Assert.assertNotNull((Object)result);
        taskService4.complete(task4.getId().longValue(), "sales-rep", null);
        System.out.println("Process instance completed");
        this.runtime.close();
        this.latch.countDown();
    }

    public TaskService getTaskService() {
        return this.runtime.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.pid)).getTaskService();
    }

    protected TaskSummary selectTaskForProcessInstance(List<TaskSummary> tasks) {
        for (TaskSummary ts : tasks) {
            if (ts.getProcessInstanceId() != this.pid) continue;
            return ts;
        }
        return null;
    }
}

