/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import java.util.HashMap;
import java.util.List;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.UserAssignmentWorkitemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class WorkitemAssignmentTest
extends JbpmTestCase {
    public WorkitemAssignmentTest() {
        super(true, true);
    }

    @Test
    public void testWorkitemAssignment() {
        this.manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/workitem/workitemAssignmentTest.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(EmptyContext.get());
        KieSession kieSession = runtimeEngine.getKieSession();
        WorkItemManager workItemManager = (WorkItemManager)kieSession.getWorkItemManager();
        workItemManager.registerWorkItemHandler("SampleUserWorkitem", (WorkItemHandler)new UserAssignmentWorkitemHandler());
        HashMap<String, String> initEmptyVars = new HashMap<String, String>();
        initEmptyVars.put("firstName", "initValue");
        initEmptyVars.put("lastName", "initValue");
        ProcessInstance pi = kieSession.startProcess("workitemassignmenttest", initEmptyVars);
        String varFirstNameOrig = (String)((WorkflowProcessInstance)pi).getVariable("firstName");
        String varLasttNameOrig = (String)((WorkflowProcessInstance)pi).getVariable("lastName");
        Assert.assertEquals((Object)"initValue", (Object)varFirstNameOrig);
        Assert.assertEquals((Object)"initValue", (Object)varLasttNameOrig);
        TaskService taskService = runtimeEngine.getTaskService();
        this.assertProcessInstanceActive(pi.getId());
        this.assertNodeTriggered(pi.getId(), new String[]{"myFirstUserTask"});
        this.assertNodeActive(pi.getId(), kieSession, new String[]{"myFirstUserTask"});
        List firstTasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)firstTasks.size());
        TaskSummary firstTaskSummary = (TaskSummary)firstTasks.get(0);
        taskService.start(firstTaskSummary.getId().longValue(), "john");
        taskService.complete(firstTaskSummary.getId().longValue(), "john", null);
        ProcessInstance processInstance = kieSession.getProcessInstance(pi.getId());
        String varFirstName = (String)((WorkflowProcessInstance)processInstance).getVariable("firstName");
        String varLasttName = (String)((WorkflowProcessInstance)processInstance).getVariable("lastName");
        Assert.assertNotNull((Object)varFirstName);
        Assert.assertNotNull((Object)varLasttName);
        Assert.assertEquals((Object)"michael", (Object)varFirstName);
        Assert.assertEquals((Object)"jordan", (Object)varLasttName);
        this.assertNodeTriggered(pi.getId(), new String[]{"SampleUserWorkitem"});
        this.assertNodeActive(pi.getId(), kieSession, new String[]{"mySecondUserTask"});
        List secondTasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)secondTasks.size());
        TaskSummary secondTaskSummary = (TaskSummary)secondTasks.get(0);
        taskService.start(secondTaskSummary.getId().longValue(), "john");
        taskService.complete(secondTaskSummary.getId().longValue(), "john", null);
        this.assertProcessInstanceCompleted(processInstance.getId());
        AuditService auditService = runtimeEngine.getAuditService();
        List firstNameVars = auditService.findVariableInstances(processInstance.getId(), "firstName");
        List lastNameVars = auditService.findVariableInstances(processInstance.getId(), "lastName");
        Assert.assertNotNull((Object)firstNameVars);
        Assert.assertNotNull((Object)lastNameVars);
        Assert.assertEquals((long)2L, (long)firstNameVars.size());
        Assert.assertEquals((Object)"initValue", (Object)((VariableInstanceLog)firstNameVars.get(0)).getValue());
        Assert.assertEquals((Object)"michael", (Object)((VariableInstanceLog)firstNameVars.get(1)).getValue());
        Assert.assertEquals((long)2L, (long)lastNameVars.size());
        Assert.assertEquals((Object)"initValue", (Object)((VariableInstanceLog)lastNameVars.get(0)).getValue());
        Assert.assertEquals((Object)"jordan", (Object)((VariableInstanceLog)lastNameVars.get(1)).getValue());
    }
}

