/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.test.JbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class IntermediateEventSubprocessCatchTest
extends JbpmTestCase {
    private static final String INTERMEDIATE_CATCH_EVENT_SUBPROCESS_PROCESS = "org/jbpm/test/regression/subprocess/IntermediateEventSubprocessCatch.bpmn2";
    private static final String INTERMEDIATE_CATCH_EVENT_SUBPROCESS_PROCESS_ID = "IntermediateEventSubprocessCatch";
    private KieSession ksession;

    @Before
    public void init() throws Exception {
        this.ksession = this.createKSession(INTERMEDIATE_CATCH_EVENT_SUBPROCESS_PROCESS);
    }

    @Test(timeout=30000L)
    public void testIntermediateCatchEventSubprocess() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                latch.countDown();
            }
        });
        ProcessInstance pi = this.ksession.startProcess(INTERMEDIATE_CATCH_EVENT_SUBPROCESS_PROCESS_ID, Collections.singletonMap("id", "1"));
        latch.await(5000L, TimeUnit.MILLISECONDS);
        this.assertProcessInstanceCompleted(pi.getId());
    }
}

