/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.HashMap;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class MainProcessExceptionHandlerTest
extends JbpmTestCase {
    private static final String MAIN_PROCESS = "org/jbpm/test/regression/subprocess/MainProcessExceptionHandler.bpmn2";
    private static final String MAIN_SUBPROCESS = "org/jbpm/test/regression/subprocess/MainSubprocessExceptionHandler.bpmn2";
    private static final String MAIN_PROCESS_ID = "com.DealWithException";

    @Test
    public void testMainSubprocessExceptionHandler() {
        KieSession kieSession = this.createKSession(MAIN_PROCESS, MAIN_SUBPROCESS);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("launchOnParent", Boolean.FALSE);
        final MutableBoolean error = new MutableBoolean(false);
        kieSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (!"StartProcess".equals(event.getNodeInstance().getNodeName())) {
                    return;
                }
                if (!MainProcessExceptionHandlerTest.MAIN_PROCESS_ID.equals(event.getProcessInstance().getProcessId())) {
                    return;
                }
                Exception e = (Exception)((WorkflowProcessInstanceImpl)event.getProcessInstance()).getVariable("event");
                error.setValue(e != null);
            }
        });
        ProcessInstance pi = kieSession.startProcess(MAIN_PROCESS_ID, params);
        this.assertProcessInstanceAborted(pi.getId());
        Assert.assertTrue((boolean)error.getValue());
    }
}

