/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.task;

import java.util.List;
import org.jbpm.services.task.admin.listener.TaskCleanUpProcessEventListener;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class HumanTaskCleanUpEarlyFlushTest
extends JbpmTestCase {
    private static final String SUBPROCESS_PARENT = "org/jbpm/test/regression/task/HumanTaskCleanUpEarlyFlush-subprocess-parent.bpmn2";
    private static final String SUBPROCESS_PARENT_ID = "org.jbpm.test.regression.task.HumanTaskCleanUpEarlyFlush-subprocess-parent";
    private static final String SUBPROCESS_CHILD1 = "org/jbpm/test/regression/task/HumanTaskCleanUpEarlyFlush-subprocess-child1.bpmn2";
    private static final String SUBPROCESS_CHILD2 = "org/jbpm/test/regression/task/HumanTaskCleanUpEarlyFlush-subprocess-child2.bpmn2";
    private static final String SIGNAL_SENDER = "org/jbpm/test/regression/task/HumanTaskCleanUpEarlyFlush-signal-sender.bpmn2";
    private static final String SIGNAL_SENDER_ID = "org.jbpm.test.regression.task.HumanTaskCleanUpEarlyFlush-signal-sender";
    private static final String SIGNAL_RECEIVER = "org/jbpm/test/regression/task/HumanTaskCleanUpEarlyFlush-signal-receiver.bpmn2";

    @Test
    public void testSubprocess() {
        this.createRuntimeManager(new String[]{SUBPROCESS_PARENT, SUBPROCESS_CHILD1, SUBPROCESS_CHILD2});
        RuntimeEngine engine = this.getRuntimeEngine();
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ksession.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(taskService));
        ProcessInstance processInstance = ksession.startProcess(SUBPROCESS_PARENT_ID);
        for (int i = 0; i < 2; ++i) {
            List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
            Assert.assertEquals((long)1L, (long)tasks.size());
            long taskId = ((TaskSummary)tasks.get(0)).getId();
            taskService.start(taskId, "john");
            taskService.complete(taskId, "john", null);
        }
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    private void testSignal(JbpmJUnitBaseTestCase.Strategy strategy) {
        this.createRuntimeManager(strategy, null, new String[]{SIGNAL_SENDER, SIGNAL_RECEIVER});
        RuntimeEngine engine = this.getRuntimeEngine();
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ksession.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(taskService));
        ksession.startProcess(SIGNAL_SENDER_ID);
    }

    @Test
    public void testSignalSingleton() {
        this.testSignal(JbpmJUnitBaseTestCase.Strategy.SINGLETON);
    }

    @Test
    public void testSignalPerRequest() {
        this.testSignal(JbpmJUnitBaseTestCase.Strategy.REQUEST);
    }

    @Test
    public void testSignalPerProcessInstance() {
        this.testSignal(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE);
    }
}

