/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.executor.AsynchronousJobEvent;
import org.jbpm.executor.AsynchronousJobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownAsyncJobListener
implements AsynchronousJobListener {
    private static final Logger logger = LoggerFactory.getLogger(CountDownAsyncJobListener.class);
    private CountDownLatch latch;

    public CountDownAsyncJobListener(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted thread while waiting for all async jobs");
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted thread while waiting for all async jobs");
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void beforeJobScheduled(AsynchronousJobEvent event) {
    }

    public void afterJobScheduled(AsynchronousJobEvent event) {
    }

    public void beforeJobExecuted(AsynchronousJobEvent event) {
    }

    public void afterJobExecuted(AsynchronousJobEvent event) {
        this.latch.countDown();
    }

    public void beforeJobCancelled(AsynchronousJobEvent event) {
    }

    public void afterJobCancelled(AsynchronousJobEvent event) {
        this.latch.countDown();
    }
}

