/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.InternalTaskService;

public class HumanTaskAssignmentTest
extends JbpmTestCase {
    private static final String GET_TASKS_OWNER_GROUP = "org/jbpm/test/regression/task/HumanTaskAssignment-getTasksOwnerGroup.bpmn2";
    private static final String GET_TASKS_OWNER_GROUP_ID = "org.jbpm.test.regression.task.HumanTaskAssignment-getTasksOwnerGroup";
    private static final String GET_TASKS_OWNER_USER = "org/jbpm/test/regression/task/HumanTaskAssignment-getTasksOwnerUser.bpmn2";
    private static final String GET_TASKS_OWNER_USER_ID = "org.jbpm.test.regression.task.HumanTaskAssignment-getTasksOwnerUser";

    @Test
    public void testGetTasksAssignedAsPotentialOwnerGroup() {
        this.createRuntimeManager(new String[]{GET_TASKS_OWNER_GROUP});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        InternalTaskService taskService = (InternalTaskService)this.getRuntimeEngine().getTaskService();
        long pid = ksession.startProcess(GET_TASKS_OWNER_GROUP_ID).getId();
        List taskList = taskService.getTasksAssignedAsPotentialOwner(null, Arrays.asList("HR"));
        Assertions.assertThat((List)taskList).hasSize(1);
        Assertions.assertThat((Comparable)((TaskSummary)taskList.get(0)).getStatus()).isEqualTo((Object)Status.Ready);
        Long taskId = ((TaskSummary)taskList.get(0)).getId();
        taskService.claim(taskId.longValue(), "mary");
        taskService.start(taskId.longValue(), "mary");
        taskService.complete(taskId.longValue(), "mary", null);
        Task task = taskService.getTaskById(taskId.longValue());
        Assertions.assertThat((Comparable)task.getTaskData().getStatus()).isEqualTo((Object)Status.Completed);
        taskList = taskService.getTasksAssignedAsPotentialOwner(null, Arrays.asList("HR"));
        Assertions.assertThat((List)taskList).hasSize(0);
        taskList = taskService.getTasksAssignedAsPotentialOwner(null, Arrays.asList("PM"));
        Assertions.assertThat((List)taskList).hasSize(1);
        Assertions.assertThat((Comparable)((TaskSummary)taskList.get(0)).getStatus()).isEqualTo((Object)Status.Ready);
        ksession.abortProcessInstance(pid);
    }

    @Test
    public void testGetTasksAssignedAsPotentialOwnerUser() {
        this.createRuntimeManager(new String[]{GET_TASKS_OWNER_USER});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        InternalTaskService taskService = (InternalTaskService)this.getRuntimeEngine().getTaskService();
        long pid = ksession.startProcess(GET_TASKS_OWNER_USER_ID).getId();
        List taskList = taskService.getTasksAssignedAsPotentialOwner("jack", new ArrayList());
        Assertions.assertThat((List)taskList).hasSize(0);
        taskList = taskService.getTasksAssignedAsPotentialOwner("mary", new ArrayList());
        Assertions.assertThat((List)taskList).hasSize(1);
        Assertions.assertThat((Comparable)((TaskSummary)taskList.get(0)).getStatus()).isEqualTo((Object)Status.Ready);
        ksession.abortProcessInstance(pid);
    }
}

