/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PessimisticLockException;
import javax.transaction.UserTransaction;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PessimisticLockTasksServiceTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(PessimisticLockTasksServiceTest.class);
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    protected Properties conf;
    protected ExternalTaskEventListener externalTaskEventListener;

    public PessimisticLockTasksServiceTest() {
        super(true, true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testPessimisticLockingOnTask() throws Exception {
        final ArrayList exceptions = new ArrayList();
        this.addEnvironmentEntry("org.kie.api.persistence.pessimistic", true);
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/Evaluation2.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        final TaskService taskService = runtimeEngine.getTaskService();
        RuntimeEnvironment runtimeEnv = ((InternalRuntimeManager)this.manager).getEnvironment();
        HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator().environment(runtimeEnv.getEnvironment()).entityManagerFactory((EntityManagerFactory)runtimeEnv.getEnvironment().get("org.kie.api.persistence.jpa.EntityManagerFactory")).userGroupCallback(runtimeEnv.getUserGroupCallback());
        RegisterableItemsFactory itemsFactory = runtimeEnv.getRegisterableItemsFactory();
        for (TaskLifeCycleEventListener taskListener : itemsFactory.getTaskListeners()) {
            configurator.listener(taskListener);
        }
        final TaskService internalTaskService = configurator.getTaskService();
        logger.info("### Starting process ###");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "salaboy");
        ProcessInstance process = ksession.startProcess("com.sample.evaluation", parameters);
        Assert.assertEquals((long)1L, (long)process.getState());
        List salaboysTasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)salaboysTasks.size());
        final long taskId = ((TaskSummary)salaboysTasks.get(0)).getId();
        final CountDownLatch t2StartLockedTask = new CountDownLatch(1);
        final CountDownLatch t1Continue = new CountDownLatch(1);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                    try {
                        ut.begin();
                        logger.info("Attempting to lock task instance");
                        taskService.start(taskId, "salaboy");
                        t2StartLockedTask.countDown();
                        t1Continue.await();
                    }
                    finally {
                        ut.rollback();
                    }
                }
                catch (Exception e) {
                    logger.error("Error on thread ", (Throwable)e);
                }
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                    try {
                        ut.begin();
                        t2StartLockedTask.await();
                        logger.info("Trying to start locked task instance");
                        try {
                            internalTaskService.start(taskId, "salaboy");
                        }
                        catch (Exception e) {
                            logger.info("Abort failed with error {}", (Object)e.getMessage());
                            exceptions.add(e);
                        }
                        finally {
                            t1Continue.countDown();
                        }
                    }
                    finally {
                        ut.rollback();
                    }
                }
                catch (Exception e) {
                    logger.error("Error on thread ", (Throwable)e);
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Assert.assertEquals((Object)PessimisticLockException.class.getName(), (Object)((Exception)exceptions.get(0)).getClass().getName());
        taskService.start(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            taskService.complete(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy", null);
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            throw ex;
        }
        List pmsTasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)pmsTasks.size());
        List hrsTasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)hrsTasks.size());
        ksession.abortProcessInstance(process.getId());
        this.assertProcessInstanceAborted(process.getId());
    }
}

