/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.collaboration;

import java.util.Collections;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.collaboration.Message;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.WorkItemHandler;

public class CollaborationTest
extends JbpmTestCase {
    public CollaborationTest() {
        super(true, true);
    }

    @Test
    public void testBoundaryMessageCollaboration() {
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/collaboration/Collaboration-BoundaryMessage.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        Long pid = ksession.startProcess("collaboration.BoundaryMessage", Collections.singletonMap("MessageId", "2")).getId();
        ksession.signalEvent("Message-collaboration", (Object)new Message("1", "example"), pid.longValue());
        this.assertProcessInstanceActive(pid);
        ksession.signalEvent("Message-collaboration", (Object)new Message("2", "example"), pid.longValue());
        this.assertProcessInstanceCompleted(pid);
    }

    @Test
    public void testStartMessageCollaboration() {
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/collaboration/Collaboration-StartMessage.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ksession.signalEvent("Message-collaboration", (Object)new Message("1", "example"));
        Assert.assertEquals((long)1L, (long)this.getLogService().findProcessInstances().size());
    }

    @Test
    public void testStartMessageCollaborationNoMatch() {
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/collaboration/Collaboration-StartMessage.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ksession.signalEvent("Message-collaboration", (Object)new Message("2", "example"));
        Assert.assertEquals((long)0L, (long)this.getLogService().findProcessInstances().size());
    }

    @Test
    public void testIntermediateMessageCollaboration() {
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/collaboration/Collaboration-IntermediateMessage.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        Long pid = ksession.startProcess("collaboration.IntermediateMessage", Collections.singletonMap("MessageId", "2")).getId();
        ksession.signalEvent("Message-collaboration", (Object)new Message("1", "example"), pid.longValue());
        this.assertProcessInstanceActive(pid);
        ksession.signalEvent("Message-collaboration", (Object)new Message("2", "example"), pid.longValue());
        this.assertProcessInstanceCompleted(pid);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIntermediateMessageCollaboration() {
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.getTestWorkItemHandler());
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/collaboration/Collaboration-IntermediateMessage.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        Long pid = ksession.startProcess("collaboration.IntermediateMessage", Collections.singletonMap("MessageId", "2")).getId();
        ksession.signalEvent("Message-collaboration", (Object)new Message(null, "example"), pid.longValue());
        this.assertProcessInstanceActive(pid);
    }
}

