/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ErrorLinkProcessTest
extends JbpmTestCase {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    public static final String PROCESS_EMPTY = "org/jbpm/test/functional/common/EmptyLinkProcess.bpmn2";
    public static final String PROCESS_MULTI_THROW = "org/jbpm/test/functional/common/MultipleThrowLinkProcess.bpmn2";
    public static final String PROCESS_MULTI_CATCH = "org/jbpm/test/functional/common/MultipleCatchLinkProcess.bpmn2";
    public static final String PROCESS_UNCONNECTED = "org/jbpm/test/functional/common/UnconnectedLinkProcess.bpmn2";
    public static final String DIFFERENT_PROCESS = "org/jbpm/test/functional/common/DifferentLinkProcess.bpmn2";

    public ErrorLinkProcessTest() {
        super(false);
    }

    @Test
    public void testEmptyLinkEvents() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("nodes do not have a name");
        this.createKSession(PROCESS_EMPTY);
    }

    @Test
    public void testMultiThrowLinkEvents() {
        Assert.assertNotNull((Object)this.createKSession(PROCESS_MULTI_THROW));
    }

    @Test
    public void testMultiCatchEvents() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("multiple catch nodes");
        this.createKSession(PROCESS_MULTI_CATCH);
    }

    @Test
    public void testUnconnectedEvents() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("not connection");
        this.createKSession(PROCESS_UNCONNECTED);
    }

    @Test
    public void testDifferentProcess() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("not connection");
        this.exceptionRule.expectMessage("subprocess");
        this.createKSession(DIFFERENT_PROCESS);
    }
}

