/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.jobexec;

import org.jbpm.test.jobexec.User;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCommandWithCallback
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(UserCommandWithCallback.class);

    public ExecutionResults execute(CommandContext ctx) {
        logger.debug("Command executed on executor with {}", (Object)ctx.getData());
        WorkItem workItem = (WorkItem)ctx.getData("workItem");
        User user = (User)workItem.getParameter("UserIn");
        user.setName(user.getName() + " after command execution");
        ExecutionResults executionResults = new ExecutionResults();
        executionResults.setData("UserOut", (Object)user);
        String callbacks = (String)ctx.getData("callbacks");
        ctx.setData("callbacks", (Object)(callbacks + ", org.jbpm.test.jobexec.UserCommandCallback"));
        double item = 0.0;
        for (int i = 0; i < 99; ++i) {
            logger.debug("User item: {}", (Object)item);
            item += 1.0;
        }
        return executionResults;
    }
}

