/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.event.MyFact;
import org.jbpm.test.wih.FirstErrorWorkItemHandler;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class AsyncIntermediateCatchSignalTest
extends JbpmTestCase {
    private static final String PROCESS_AICS = "org.jbpm.test.functional.async.AsyncIntermediateCatchSignal";
    private static final String BPMN_AICS = "org/jbpm/test/functional/async/AsyncIntermediateCatchSignal.bpmn2";
    private static final String CONDITION_CATCH = "org/jbpm/test/functional/async/ConditionEventGatewayTest.bpmn2";
    private static final String CONDITION_CATCH_ID = "org.jbpm.test.functional.async.eventgatewaytest";
    private ExecutorService executorService;
    private CountDownLatch latch;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(0);
        this.executorService.setThreadPoolSize(3);
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addWorkItemHandler("SyncError", (WorkItemHandler)new FirstErrorWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                AsyncIntermediateCatchSignalTest.this.latch.countDown();
            }
        });
        this.executorService.init();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    @Test(timeout=10000L)
    public void testCorrectProcessStateAfterExceptionSignalCommand() throws InterruptedException {
        this.latch = new CountDownLatch(1);
        RuntimeManager runtimeManager = this.createRuntimeManager(new String[]{BPMN_AICS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        ProcessInstance pi = ksession.startProcess(PROCESS_AICS);
        long pid = pi.getId();
        CommandContext ctx = new CommandContext();
        ctx.setData("DeploymentId", (Object)runtimeManager.getIdentifier());
        ctx.setData("ProcessInstanceId", (Object)pid);
        ctx.setData("Signal", (Object)"MySignal");
        ctx.setData("Event", null);
        this.executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
        this.latch.await();
    }

    @Test(timeout=20000L)
    public void testCorrectProcessStateAfterExceptionSignalCommandMulti() throws InterruptedException {
        this.latch = new CountDownLatch(5);
        RuntimeManager runtimeManager = this.createRuntimeManager(new String[]{BPMN_AICS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        long[] pid = new long[5];
        for (int i = 0; i < 5; ++i) {
            ProcessInstance pi = ksession.startProcess(PROCESS_AICS);
            pid[i] = pi.getId();
            CommandContext ctx = new CommandContext();
            ctx.setData("DeploymentId", (Object)runtimeManager.getIdentifier());
            ctx.setData("ProcessInstanceId", (Object)pi.getId());
            ctx.setData("Signal", (Object)"MySignal");
            ctx.setData("Event", null);
            this.executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
        }
        this.latch.await();
        for (long p : pid) {
            ProcessInstance pi = ksession.getProcessInstance(p);
            Assertions.assertThat((Object)pi).isNull();
        }
    }

    @Test(timeout=10000L, expected=WorkflowRuntimeException.class)
    public void testSyncGlobalSignal() {
        KieSession ksession = this.createKSession(BPMN_AICS);
        ksession.startProcess(PROCESS_AICS);
        ksession.signalEvent("MySignal", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCondition() throws Exception {
        int count = 100;
        this.latch = new CountDownLatch(count);
        ArrayList<Long> pids = new ArrayList<Long>();
        RuntimeManager rm = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, null, new String[]{CONDITION_CATCH});
        for (int i = 0; i < count; ++i) {
            RuntimeEngine engine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
            pids.add(engine.getKieSession().startProcess(CONDITION_CATCH_ID).getId());
            rm.disposeRuntimeEngine(engine);
        }
        MyFact myFact = new MyFact();
        myFact.setConditionA(true);
        rm.signalEvent("ASYNC-signalA", (Object)myFact);
        this.latch.await();
        Iterator iterator = pids.iterator();
        while (iterator.hasNext()) {
            long p = (Long)iterator.next();
            RuntimeEngine engine = rm.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)p));
            try {
                engine.getKieSession();
                Assert.fail();
            }
            catch (SessionNotFoundException sessionNotFoundException) {}
            continue;
            finally {
                rm.disposeRuntimeEngine(engine);
            }
        }
    }
}

