/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.workitem.bpmn2.ServiceTaskHandler;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class AsyncThreadIsolationTest
extends JbpmTestCase {
    private static Object LOCK = new Object();
    private static final String PROCESS_ATI = "org.jbpm.test.functional.async.AsyncThreadIsolation";
    private static final String BPMN_ATI = "org/jbpm/test/functional/async/AsyncThreadIsolation.bpmn2";
    private ExecutorService executorService;
    private boolean firstAttempt = true;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Async Hello Service Exception")) {
                    if (AsyncThreadIsolationTest.this.firstAttempt) {
                        AsyncThreadIsolationTest.this.firstAttempt = false;
                    } else {
                        Object object = LOCK;
                        synchronized (object) {
                            LOCK.notifyAll();
                        }
                    }
                }
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectProcessStateAfterException() {
        KieSession ksession = this.createKSession(BPMN_ATI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", "Ivo");
        ProcessInstance pi = ksession.startProcess(PROCESS_ATI, params);
        Object object = LOCK;
        synchronized (object) {
            try {
                LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List vars = this.getLogService().findVariableInstances(pi.getId(), "message");
        ArrayList<String> varValues = new ArrayList<String>();
        for (VariableInstanceLog v : vars) {
            varValues.add(v.getValue());
        }
        Assertions.assertThat(varValues).contains((Object[])new String[]{"Hello Ivo asynchronously"});
        pi = ksession.getProcessInstance(pi.getId());
        Assertions.assertThat((Object)pi).isNotNull();
        Assertions.assertThat((int)pi.getState()).isEqualTo(1);
        EntityManager em = this.getEmf().createEntityManager();
        List logs = em.createQuery("SELECT o FROM NodeInstanceLog o WHERE o.type = :type", NodeInstanceLog.class).setParameter("type", (Object)6).getResultList();
        em.close();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertNotNull((Object)((NodeInstanceLog)logs.get(0)).getObservation());
    }
}

