/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.assignment.AssignmentServiceRegistry;
import org.jbpm.services.task.assignment.impl.AssignmentImpl;
import org.jbpm.services.task.assignment.impl.AssignmentServiceImpl;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.persistence.processinstance.objects.TestEventEmitter;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskContext;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHumanTaskTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHumanTaskTest.class);

    public ProcessHumanTaskTest() {
        super(true, false);
    }

    @Test
    public void testProcess() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessWithHumanTaskAndCustomAssigmentStrategy() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskWithCustomAssignmentStrategy.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        AssignmentServiceRegistry.get().addStrategy(new AssignmentStrategy(){

            public String getIdentifier() {
                return "CustomStrategy";
            }

            public Assignment apply(Task task, TaskContext context, String excludedUser) {
                return new AssignmentImpl("doctor");
            }
        });
        AssignmentServiceProvider.get().setEnabled(true);
        try {
            ProcessInstance processInstance = ksession.startProcess("humanTaskWithCustomStrategy", Collections.singletonMap("processHTInput", "CustomStrategy"));
            List listIds = taskService.getTasksByProcessInstanceId(processInstance.getId());
            List list = listIds.stream().map(arg_0 -> ((TaskService)taskService).getTaskById(arg_0)).collect(Collectors.toList());
            Task task = (Task)list.get(0);
            logger.info("doctor is executing task {}", (Object)task.getName());
            taskService.start(task.getId().longValue(), "doctor");
            taskService.complete(task.getId().longValue(), "doctor", null);
            this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
        }
        finally {
            AssignmentServiceRegistry.get().reset();
            ((AssignmentServiceImpl)AssignmentServiceProvider.get()).reset();
        }
    }

    @Test
    public void testProcessWithCreatedBy() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantaskwithcreatedby.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("person", "krisv");
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello.createdby", params);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        Assert.assertEquals((Object)"mary", (Object)task.getCreatedById());
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        Assert.assertEquals((Object)"krisv", (Object)task.getCreatedById());
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessRequestStrategy() {
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.REQUEST, "manager", new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessProcessInstanceStrategy() {
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "manager", new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        long ksessionID = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        manager.disposeRuntimeEngine(runtimeEngine);
        runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        Assert.assertEquals((long)ksessionID, (long)ksession.getIdentifier());
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
        manager.disposeRuntimeEngine(runtimeEngine);
    }

    @Test
    public void testProcessAndTaskIntegrationWithEventManager() {
        this.sessionPersistence = true;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        Set events = TestEventEmitter.getEvents();
        Assert.assertEquals((long)11L, (long)events.size());
        Assert.assertEquals((long)1L, (long)events.stream().filter(instanceView -> instanceView instanceof ProcessInstanceView).count());
        Assert.assertEquals((long)2L, (long)events.stream().filter(instanceView -> instanceView instanceof TaskInstanceView).count());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testHumanTaskWithSuspendUntil() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.addTaskEventListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void afterTaskResumedEvent(TaskEvent event) {
                latch.countDown();
            }
        });
        this.sessionPersistence = true;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskWithSuspendUntil.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("humanTaskWithSuspendUntil");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        logger.info("John is suspending task {}", (Object)task.getName());
        taskService.suspend(task.getId().longValue(), "john");
        latch.await();
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testHumanTaskWithSuspendUntilWithParameter() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.addTaskEventListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void afterTaskResumedEvent(TaskEvent event) {
                latch.countDown();
            }
        });
        this.sessionPersistence = true;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskWithSuspendUntil.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("humanTaskWithSuspendUntil");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        logger.info("John is suspending task {}", (Object)task.getName());
        long start = System.currentTimeMillis();
        taskService.suspend(task.getId().longValue(), "john", Collections.singletonMap("suspendUntil", "PT3S"));
        latch.await();
        long total = System.currentTimeMillis() - start;
        Assert.assertTrue((total >= 3000L ? 1 : 0) != 0);
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testHumanTaskWithSuspendUntilRemoveTimer() throws Exception {
        final CountDownLatch latch = new CountDownLatch(2);
        this.addTaskEventListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void afterTaskResumedEvent(TaskEvent event) {
                latch.countDown();
            }
        });
        this.sessionPersistence = true;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskWithSuspendUntil.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("humanTaskWithSuspendUntil");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        logger.info("John is suspending task {}", (Object)task.getName());
        taskService.suspend(task.getId().longValue(), "john");
        taskService.resume(task.getId().longValue(), "Administrator");
        taskService.complete(task.getId().longValue(), "john", null);
        Assert.assertFalse((boolean)latch.await(5L, TimeUnit.SECONDS));
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }
}

