/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class StartEventTest
extends JbpmTestCase {
    private static final String CONDITIONAL = "org/jbpm/test/functional/event/StartEvent-conditional.bpmn2";
    private static final String CONDITIONAL_ID = "org.jbpm.test.functional.event.StartEvent-conditional";
    private static final String MESSAGE = "org/jbpm/test/functional/event/StartEvent-message.bpmn2";
    private static final String MESSAGE_ID = "org.jbpm.test.functional.event.StartEvent-message";
    private static final String NONE = "org/jbpm/test/functional/event/StartEvent-none.bpmn2";
    private static final String NONE_ID = "org.jbpm.test.functional.event.StartEvent-none";
    private static final String SIGNAL = "org/jbpm/test/functional/event/StartEvent-signal.bpmn2";
    private static final String SIGNAL_ID = "org.jbpm.test.functional.event.StartEvent-signal";
    private static final String TIMER_CYCLE = "org/jbpm/test/functional/event/StartEvent-timer-cycle.bpmn2";
    private static final String TIMER_CYCLE_ID = "org.jbpm.test.functional.event.StartEvent-timer-cycle";
    private static final String TIMER_DURATION = "org/jbpm/test/functional/event/StartEvent-timer-duration.bpmn2";
    private static final String TIMER_DURATION_ID = "org.jbpm.test.functional.event.StartEvent-timer-duration";
    private static final String MULTIPLE_START_TIMER = "org/jbpm/test/functional/event/StartEvent-MultipleTimers.bpmn2";
    private static final String MULTIPLE_START_TIMER_ID = "org.jbpm.test.functional.event.StartEvent-MultipleTimers";

    public StartEventTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testConditionalStartEvent() {
        KieSession ksession = this.createKSession(CONDITIONAL);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(StartEventTest.getCommands().newInsert((Object)"condition"));
        ksession.execute((Command)StartEventTest.getCommands().newBatchExecution(cmds, null));
        Assertions.assertThat((boolean)process.wasProcessStarted(CONDITIONAL_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(CONDITIONAL_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)CONDITIONAL_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)CONDITIONAL_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @Test(timeout=30000L)
    public void testMessageStartEvent() {
        KieSession ksession = this.createKSession(MESSAGE);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = StartEventTest.getCommands().newSignalEvent("Message-type", null);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(MESSAGE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(MESSAGE_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)MESSAGE_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)MESSAGE_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @Test(timeout=30000L)
    public void testNoneStartEvent() {
        KieSession ksession = this.createKSession(NONE);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = StartEventTest.getCommands().newStartProcess(NONE_ID);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(NONE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(NONE_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)NONE_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)NONE_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @Test(timeout=30000L)
    public void testSignalStartEvent() {
        KieSession ksession = this.createKSession(SIGNAL);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = StartEventTest.getCommands().newSignalEvent("start", null);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(SIGNAL_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(SIGNAL_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)SIGNAL_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)SIGNAL_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @Test(timeout=30000L)
    public void testRecurringTimerStartEvent() throws Exception {
        KieSession ksession = this.createKSession(TIMER_CYCLE);
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)process);
        ksession.fireAllRules();
        Assert.assertTrue((String)"The process did not start on time!", (boolean)process.waitForProcessToStart(1000L));
        Assert.assertTrue((String)"The process did not complete on time!", (boolean)process.waitForProcessToComplete(1000L));
        Assertions.assertThat((boolean)process.wasProcessStarted(TIMER_CYCLE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(TIMER_CYCLE_ID)).isTrue();
        process.clear();
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((String)"The process was not triggered on time!", (boolean)process.waitForProcessToStart(1000L));
            Assert.assertTrue((String)"The process did not complete on time!", (boolean)process.waitForProcessToComplete(1000L));
            Assertions.assertThat((boolean)process.wasProcessStarted(TIMER_CYCLE_ID)).isTrue();
            Assertions.assertThat((boolean)process.wasProcessCompleted(TIMER_CYCLE_ID)).isTrue();
            process.clear();
        }
    }

    @Test(timeout=30000L)
    public void testDelayingTimerStartEvent() throws Exception {
        KieSession ksession = this.createKSession(TIMER_DURATION);
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)process);
        ksession.fireAllRules();
        Assert.assertTrue((String)"The process did not start on time!", (boolean)process.waitForProcessToStart(1000L));
        Assert.assertTrue((String)"The process did not complete on time!", (boolean)process.waitForProcessToComplete(1000L));
        ksession.fireAllRules();
        Assertions.assertThat((boolean)process.wasProcessStarted(TIMER_DURATION_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(TIMER_DURATION_ID)).isTrue();
        process.clear();
    }

    @Test(timeout=30000L)
    public void testStartMultipleTimer() throws Exception {
        KieSession ksession = this.createKSession(MULTIPLE_START_TIMER);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener(2);
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        process.waitForProcessToComplete(4000L);
        Assertions.assertThat((boolean)process.wasProcessStarted(MULTIPLE_START_TIMER_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(MULTIPLE_START_TIMER_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)MULTIPLE_START_TIMER_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"2s");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"Task2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end1");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)MULTIPLE_START_TIMER_ID);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)MULTIPLE_START_TIMER_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"3s");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"Task1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end2");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)MULTIPLE_START_TIMER_ID);
    }
}

