/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;

public class MultipleTasksLoopSubprocessTest
extends JbpmTestCase {
    private static final String DYNAMIC_PARENT_PROCESS = "org/jbpm/test/regression/subprocess/MultipleTasksLoopParentProcess.bpmn";
    private static final String DYNAMIC_CHILD_SUBPROCESS = "org/jbpm/test/regression/subprocess/MultipleTasksLoopSubProcess.bpmn";
    private static final String DYNAMIC_PARENT_PROCESS_ID = "MultipleTasksLoopParentProcess";
    private static final String JOHN = "john";
    private KieSession ksession;
    private TaskService taskService;
    private RuntimeManager runtimeManager;
    private RuntimeEngine engine;

    @Before
    public void init() {
        System.setProperty("jbpm.enable.multi.con", "true");
        this.runtimeManager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "MultipleTasksLoopSubprocessTest", new String[]{DYNAMIC_PARENT_PROCESS, DYNAMIC_CHILD_SUBPROCESS});
        this.engine = this.getRuntimeEngine();
        this.ksession = this.engine.getKieSession();
        this.taskService = this.engine.getTaskService();
    }

    @After
    public void cleanup() {
        this.runtimeManager.disposeRuntimeEngine(this.engine);
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testDuplicateTasksAfterSubProcess() {
        Assertions.assertThat((Object)this.ksession).isNotNull();
        long pid = this.ksession.startProcess(DYNAMIC_PARENT_PROCESS_ID).getId();
        this.assertProcessInstanceActive(pid);
        Assertions.assertThat((Object)this.ksession.getProcessInstance(pid, true)).isNotNull();
        Assert.assertEquals((long)1L, (long)this.getLogService().findSubProcessInstances(pid).size());
        long subPid = ((ProcessInstanceLog)this.getLogService().findSubProcessInstances(pid).get(0)).getProcessInstanceId();
        List tasks = this.taskService.getTasksByProcessInstanceId(subPid);
        Task task = this.taskService.getTaskById(((Long)tasks.get(0)).longValue());
        this.taskService.start(task.getId().longValue(), JOHN);
        this.taskService.complete(task.getId().longValue(), JOHN, Collections.emptyMap());
        this.assertProcessInstanceCompleted(subPid);
        this.assertProcessInstanceActive(pid);
        tasks = this.taskService.getTasksByProcessInstanceId(pid);
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.ksession.abortProcessInstance(pid);
        this.assertProcessInstanceAborted(pid);
    }
}

