/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.jdbc.TransactionalDriver;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class PoolingDataSource
implements DataSource {
    private final TransactionalDriver transactionalDriver = new TransactionalDriver();
    private Properties driverProperties = new Properties();
    private String uniqueName;
    private String className;
    private XADataSource xads;
    private Connection connection;

    public PoolingDataSource() {
        try {
            new InitialContext().rebind("java:comp/UserTransaction", (Object)UserTransaction.userTransaction());
            new InitialContext().rebind("java:comp/TransactionManager", (Object)TransactionManager.transactionManager());
            new InitialContext().rebind("java:comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryImple());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void init() {
        try {
            this.xads = (XADataSource)Class.forName(this.className).newInstance();
            String url = this.driverProperties.getProperty("url", this.driverProperties.getProperty("URL"));
            this.xads.getClass().getMethod("setURL", String.class).invoke((Object)this.xads, url);
            new InitialContext().rebind(this.uniqueName, (Object)this);
            this.connection = this.getConnection(this.driverProperties.getProperty("user"), this.driverProperties.getProperty("password"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException | NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.connection.close();
            new InitialContext().unbind(this.uniqueName);
        }
        catch (SQLException | NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.driverProperties.getProperty("user") != null) {
            return this.getConnection(this.driverProperties.getProperty("user"), this.driverProperties.getProperty("password"));
        }
        Properties properties = new Properties();
        properties.put(TransactionalDriver.XADataSource, this.xads);
        return this.transactionalDriver.connect("jdbc:arjuna:" + this.uniqueName, properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties properties = new Properties();
        properties.put(TransactionalDriver.XADataSource, this.xads);
        properties.put("user", username);
        if (password != null) {
            properties.put("password", password);
        }
        return this.transactionalDriver.connect("jdbc:arjuna:" + this.uniqueName, properties);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

