/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.jdbc.TransactionalDriver;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(PoolingDataSource.class);
    private final TransactionalDriver transactionalDriver = new TransactionalDriver();
    private Properties driverProperties = new Properties();
    private String uniqueName;
    private String className;
    private XADataSource xads;
    private Connection connection;

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void setDriverProperties(Properties driverProperties) {
        this.driverProperties = driverProperties;
    }

    public void init() {
        try {
            this.xads = (XADataSource)Class.forName(this.className).newInstance();
            String url = this.driverProperties.getProperty("url", this.driverProperties.getProperty("URL"));
            logger.info(url);
            if (!this.className.startsWith("com.ibm.db2") && !this.className.startsWith("com.sybase")) {
                try {
                    this.xads.getClass().getMethod("setUrl", String.class).invoke((Object)this.xads, url);
                }
                catch (NoSuchMethodException ex) {
                    logger.info("Unable to find \"setUrl\" method in db driver JAR. Trying \"setURL\" ");
                    this.xads.getClass().getMethod("setURL", String.class).invoke((Object)this.xads, url);
                }
                catch (InvocationTargetException ex) {
                    logger.info("Driver does not support setURL and setUrl method.");
                    throw new RuntimeException(ex);
                }
            } else {
                this.setupAdditionalDriverProperties(this.className);
            }
            try {
                InitialContext initContext = new InitialContext();
                initContext.rebind(this.uniqueName, (Object)this);
                initContext.rebind("java:comp/UserTransaction", (Object)UserTransaction.userTransaction());
                initContext.rebind("java:comp/TransactionManager", (Object)TransactionManager.transactionManager());
                initContext.rebind("java:comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryImple());
            }
            catch (NamingException e) {
                logger.warn("No InitialContext available, resource won't be accessible via lookup");
            }
            this.connection = this.getConnection(this.driverProperties.getProperty("user"), this.driverProperties.getProperty("password"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.connection.close();
            new InitialContext().unbind(this.uniqueName);
        }
        catch (SQLException | NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.driverProperties.getProperty("user") != null) {
            return this.getConnection(this.driverProperties.getProperty("user"), this.driverProperties.getProperty("password"));
        }
        Properties properties = this.getDriverProperties();
        properties.put(TransactionalDriver.XADataSource, this.xads);
        return this.transactionalDriver.connect("jdbc:arjuna:" + this.uniqueName, properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties properties = this.getDriverProperties();
        properties.put(TransactionalDriver.XADataSource, this.xads);
        properties.put("user", username);
        if (password != null) {
            properties.put("password", password);
        }
        return this.transactionalDriver.connect("jdbc:arjuna:" + this.uniqueName, properties);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private void setupAdditionalDriverProperties(String className) {
        try {
            this.xads.getClass().getMethod("setServerName", String.class).invoke((Object)this.xads, this.driverProperties.getProperty("serverName"));
            this.xads.getClass().getMethod("setDatabaseName", String.class).invoke((Object)this.xads, this.driverProperties.getProperty("databaseName"));
            if (className.startsWith("com.ibm.db2")) {
                this.xads.getClass().getMethod("setDriverType", Integer.TYPE).invoke((Object)this.xads, 4);
                this.xads.getClass().getMethod("setPortNumber", Integer.TYPE).invoke((Object)this.xads, Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                this.xads.getClass().getMethod("setResultSetHoldability", Integer.TYPE).invoke((Object)this.xads, 1);
                this.xads.getClass().getMethod("setDowngradeHoldCursorsUnderXa", Boolean.TYPE).invoke((Object)this.xads, true);
            } else if (className.startsWith("com.sybase")) {
                this.xads.getClass().getMethod("setPortNumber", Integer.TYPE).invoke((Object)this.xads, Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                this.xads.getClass().getMethod("setPassword", String.class).invoke((Object)this.xads, this.driverProperties.getProperty("password"));
                this.xads.getClass().getMethod("setUser", String.class).invoke((Object)this.xads, this.driverProperties.getProperty("user"));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            logger.error("Exception thrown while setting properties for {} driver", (Object)className);
            throw new RuntimeException(ex);
        }
    }
}

