/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.test.util.Version;

public class DatabaseScript
implements Comparable<DatabaseScript> {
    private String name;
    private Version from;
    private Version to;
    private File script;

    public DatabaseScript(File script) {
        this(script.getName());
        this.script = script;
    }

    public DatabaseScript(String value) {
        Pattern pattern = Pattern.compile("(.*)-(\\d+\\.\\d+)-to-(\\d+\\.\\d+).sql");
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches() && matcher.groupCount() == 3) {
            this.name = matcher.group(1);
            this.from = new Version(matcher.group(2));
            this.to = new Version(matcher.group(3));
        } else {
            this.name = value;
        }
    }

    public File getScript() {
        return this.script;
    }

    public String getName() {
        return this.name;
    }

    public Version getTo() {
        return this.to;
    }

    public Version getFrom() {
        return this.from;
    }

    @Override
    public int compareTo(DatabaseScript o) {
        if (this.name.equals(o.name)) {
            if (this.from == null || o.from == null) {
                return this.name.compareTo(o.name);
            }
            return this.from.compareTo(o.from);
        }
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseScript) {
            return this.compareTo((DatabaseScript)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.from != null && this.to != null ? "Script " + this.name + " from version " + this.from + " to " + this.to : "Script " + this.name;
    }
}

