/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.workbench.cm.backend.server.CaseInstanceMapper;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseStage;

public class CaseInstanceMapperTest {
    public static void assertCaseInstance(CaseInstance ci, CaseInstanceSummary cis) {
        Assert.assertNotNull((Object)cis);
        Assert.assertEquals((Object)ci.getCaseId(), (Object)cis.getCaseId());
        Assert.assertEquals((Object)ci.getContainerId(), (Object)cis.getContainerId());
        Assert.assertEquals((Object)ci.getCaseStatus(), (Object)cis.getStatus());
        Assert.assertEquals((Object)ci.getCaseDescription(), (Object)cis.getDescription());
        Assert.assertEquals((Object)ci.getCaseOwner(), (Object)cis.getOwner());
        Assert.assertEquals((Object)ci.getStartedAt(), (Object)cis.getStartedAt());
        Assert.assertEquals((Object)ci.getCompletedAt(), (Object)cis.getCompletedAt());
        Assert.assertEquals((Object)ci.getCaseDefinitionId(), (Object)cis.getCaseDefinitionId());
        CaseInstanceMapperTest.assertCaseStages(ci.getStages(), cis.getStages());
    }

    public static void assertCaseStages(List<CaseStage> csl, List<CaseStageSummary> cssl) {
        Assert.assertNotNull(cssl);
        if (csl == null) {
            Assert.assertEquals((long)0L, (long)cssl.size());
        } else {
            Assert.assertEquals((long)cssl.size(), (long)csl.size());
            for (int i = 0; i < csl.size(); ++i) {
                CaseStage caseStage = csl.get(i);
                CaseStageSummary caseStageSummary = cssl.get(i);
                Assert.assertEquals((Object)caseStageSummary.getName(), (Object)caseStage.getName());
                Assert.assertEquals((Object)caseStageSummary.getIdentifier(), (Object)caseStage.getIdentifier());
                Assert.assertEquals((Object)caseStageSummary.getStatus(), (Object)caseStage.getStatus());
            }
        }
    }

    @Test
    public void testCaseInstanceMapper_mapCaseInstance() {
        CaseInstance ci = this.createCaseInstance();
        ArrayList<CaseStage> stagesList = new ArrayList<CaseStage>();
        stagesList.add(CaseStage.builder().name("stage1").status("Available").id("stage1").build());
        stagesList.add(CaseStage.builder().name("stage2").status("Completed").id("stage2").build());
        ci.setStages(stagesList);
        CaseInstanceSummary cis = new CaseInstanceMapper().apply(ci);
        CaseInstanceMapperTest.assertCaseInstance(ci, cis);
    }

    @Test
    public void testCaseInstanceMapper_mapNull() {
        CaseInstance ci = null;
        CaseInstanceSummary cis = new CaseInstanceMapper().apply(ci);
        Assert.assertNull((Object)cis);
    }

    private CaseInstance createCaseInstance() {
        return CaseInstance.builder().caseDescription("New case").caseId("CASE-1").caseStatus(Integer.valueOf(1)).containerId("org.jbpm").caseDefinitionId("org.jbpm.case").caseOwner("admin").startedAt(new Date()).completedAt(new Date()).build();
    }
}

