/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.cm.backend.server.CaseActionAdHocMapper;
import org.jbpm.workbench.cm.backend.server.CaseActionNodeInstanceMapper;
import org.jbpm.workbench.cm.backend.server.CaseCommentMapper;
import org.jbpm.workbench.cm.backend.server.CaseDefinitionMapper;
import org.jbpm.workbench.cm.backend.server.CaseInstanceMapper;
import org.jbpm.workbench.cm.backend.server.CaseMilestoneMapper;
import org.jbpm.workbench.cm.backend.server.ProcessDefinitionMapper;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseCommentSummary;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseMilestoneSummary;
import org.jbpm.workbench.cm.model.ProcessDefinitionSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.Actions;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;
import org.jbpm.workbench.cm.util.CaseInstanceSortBy;
import org.jbpm.workbench.cm.util.CaseMilestoneSearchRequest;
import org.jbpm.workbench.cm.util.CaseStageStatus;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.UserTaskServicesClient;

@Service
@ApplicationScoped
public class RemoteCaseManagementServiceImpl
implements CaseManagementService {
    public static final int PAGE_SIZE_UNLIMITED = Integer.MAX_VALUE;
    public static final String CASE_OWNER_ROLE = "owner";
    public static final List<String> NODE_TYPE_HUMAN_TASK = Arrays.asList("Human Task", "HumanTaskNode");
    @Inject
    private CaseServicesClient client;
    @Inject
    private UserTaskServicesClient userTaskServicesClient;

    public List<CaseDefinitionSummary> getCaseDefinitions() {
        List caseDefinitions = this.client.getCaseDefinitions(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return caseDefinitions.stream().map(new CaseDefinitionMapper()).collect(Collectors.toList());
    }

    public CaseDefinitionSummary getCaseDefinition(String serverTemplateId, String containerId, String caseDefinitionId) {
        return Optional.ofNullable(this.client.getCaseDefinition(containerId, caseDefinitionId)).map(new CaseDefinitionMapper()).orElse(null);
    }

    public List<CaseInstanceSummary> getCaseInstances(CaseInstanceSearchRequest request) {
        List caseInstances = this.client.getCaseInstances(Collections.singletonList(request.getStatus()), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        Comparator<CaseInstanceSummary> comparator = this.getCaseInstanceSummaryComparator(request);
        return caseInstances.stream().map(new CaseInstanceMapper()).sorted(comparator).collect(Collectors.toList());
    }

    protected Comparator<CaseInstanceSummary> getCaseInstanceSummaryComparator(CaseInstanceSearchRequest request) {
        Comparator<CaseInstanceSummary> comparator;
        switch (Optional.ofNullable(request.getSortBy()).orElse(CaseInstanceSortBy.CASE_ID)) {
            case START_TIME: {
                comparator = Comparator.comparing(CaseInstanceSummary::getStartedAt);
                break;
            }
            default: {
                comparator = Comparator.comparing(CaseInstanceSummary::getCaseId);
            }
        }
        return request.getSortByAsc() != false ? comparator : comparator.reversed();
    }

    public String startCaseInstance(String serverTemplateId, String containerId, String caseDefinitionId, String owner) {
        CaseFile caseFile = CaseFile.builder().addUserAssignments(CASE_OWNER_ROLE, owner).build();
        return this.client.startCase(containerId, caseDefinitionId, caseFile);
    }

    public void cancelCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.client.cancelCaseInstance(containerId, caseId);
    }

    public void destroyCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.client.destroyCaseInstance(containerId, caseId);
    }

    public CaseInstanceSummary getCaseInstance(String serverTemplateId, String containerId, String caseId) {
        return Optional.ofNullable(this.client.getCaseInstance(containerId, caseId, true, true, true, true)).map(new CaseInstanceMapper()).orElse(null);
    }

    public void assignUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.client.assignUserToRole(containerId, caseId, roleName, user);
    }

    public void assignGroupToRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.client.assignGroupToRole(containerId, caseId, roleName, group);
    }

    public void assignGroupAndUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user, String group) {
        this.client.assignGroupToRole(containerId, caseId, roleName, group);
        this.client.assignUserToRole(containerId, caseId, roleName, user);
    }

    public void removeUserFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.client.removeUserFromRole(containerId, caseId, roleName, user);
    }

    public void removeGroupFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.client.removeGroupFromRole(containerId, caseId, roleName, group);
    }

    public List<CaseCommentSummary> getComments(String serverTemplateId, String containerId, String caseId) {
        List caseComments = this.client.getComments(containerId, caseId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return caseComments.stream().map(new CaseCommentMapper()).collect(Collectors.toList());
    }

    public void addComment(String serverTemplateId, String containerId, String caseId, String author, String text) {
        this.client.addComment(containerId, caseId, author, text);
    }

    public void updateComment(String serverTemplateId, String containerId, String caseId, String commentId, String author, String text) {
        this.client.updateComment(containerId, caseId, commentId, author, text);
    }

    public void removeComment(String serverTemplateId, String containerId, String caseId, String commentId) {
        this.client.removeComment(containerId, caseId, commentId);
    }

    public List<CaseMilestoneSummary> getCaseMilestones(String containerId, String caseId, CaseMilestoneSearchRequest request) {
        List caseMilestones = this.client.getMilestones(containerId, caseId, false, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        Comparator<CaseMilestoneSummary> comparator = this.getCaseMilestoneSummaryComparator(request);
        return caseMilestones.stream().map(new CaseMilestoneMapper()).sorted(comparator).collect(Collectors.toList());
    }

    protected Comparator<CaseMilestoneSummary> getCaseMilestoneSummaryComparator(CaseMilestoneSearchRequest request) {
        Comparator<CaseMilestoneSummary> comparatorByName = Comparator.comparing(CaseMilestoneSummary::getName);
        return Comparator.comparing(CaseMilestoneSummary::getStatus).thenComparing(request.getSortByAsc() != false ? comparatorByName : comparatorByName.reversed());
    }

    public Actions getCaseActions(String serverTemplateId, String container, String caseId, String userId) {
        Actions actions = new Actions();
        actions.setAvailableActions(this.getAdHocActions(serverTemplateId, container, caseId));
        actions.setInProgressAction(this.getInProgressActions(container, caseId));
        actions.setCompleteActions(this.getCompletedActions(container, caseId));
        return actions;
    }

    public List<CaseActionSummary> getInProgressActions(String containerId, String caseId) {
        List activeNodes = this.client.getActiveNodes(containerId, caseId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return activeNodes.parallelStream().map(s -> new CaseActionNodeInstanceMapper(NODE_TYPE_HUMAN_TASK.contains(s.getNodeType()) ? this.userTaskServicesClient.findTaskByWorkItemId(s.getWorkItemId()).getActualOwner() : "", CaseActionStatus.IN_PROGRESS).apply((NodeInstance)s)).collect(Collectors.toList());
    }

    public List<NodeInstance> getCaseCompletedNodes(String containerId, String caseId) {
        return new ArrayList<NodeInstance>();
    }

    public List<CaseActionSummary> getCompletedActions(String containerId, String caseId) {
        List<NodeInstance> activeNodes = this.getCaseCompletedNodes(containerId, caseId);
        return activeNodes.parallelStream().map(s -> new CaseActionNodeInstanceMapper(NODE_TYPE_HUMAN_TASK.contains(s.getNodeType()) ? this.userTaskServicesClient.findTaskByWorkItemId(s.getWorkItemId()).getActualOwner() : "", CaseActionStatus.COMPLETED).apply((NodeInstance)s)).collect(Collectors.toList());
    }

    public List<CaseActionSummary> getAdHocFragments(String containerId, String caseId) {
        return this.client.getAdHocFragments(containerId, caseId).stream().map(new CaseActionAdHocMapper("")).collect(Collectors.toList());
    }

    public List<CaseActionSummary> getAdHocActions(String serverTemplateId, String containerId, String caseId) {
        List<CaseActionSummary> adHocActions = this.getAdHocFragments(containerId, caseId);
        CaseInstanceSummary caseInstanceSummary = this.getCaseInstance(serverTemplateId, containerId, caseId);
        caseInstanceSummary.getStages().stream().filter(s -> s.getStatus().equals(CaseStageStatus.ACTIVE.getStatus())).forEach(ah -> {
            if (ah.getAdHocActions().size() > 0) {
                adHocActions.addAll(ah.getAdHocActions());
            }
        });
        return adHocActions;
    }

    public void addDynamicUserTask(String containerId, String caseId, String name, String description, String actors, String groups, Map<String, Object> data) {
        this.client.addDynamicUserTask(containerId, caseId, name, description, actors, groups, data);
    }

    public void addDynamicUserTaskToStage(String containerId, String caseId, String stageId, String name, String description, String actors, String groups, Map<String, Object> data) {
        this.client.addDynamicUserTaskToStage(containerId, caseId, stageId, name, description, actors, groups, data);
    }

    public void addDynamicSubProcess(String containerId, String caseId, String processId, Map<String, Object> data) {
        this.client.addDynamicSubProcess(containerId, caseId, processId, data);
    }

    public void addDynamicSubProcessToStage(String containerId, String caseId, String stageId, String processId, Map<String, Object> data) {
        this.client.addDynamicSubProcessToStage(containerId, caseId, stageId, processId, data);
    }

    public void triggerAdHocActionInStage(String containerId, String caseId, String stageId, String adHocName, Map<String, Object> data) {
        this.client.triggerAdHocFragmentInStage(containerId, caseId, stageId, adHocName, data);
    }

    public void triggerAdHocAction(String containerId, String caseId, String adHocName, Map<String, Object> data) {
        this.client.triggerAdHocFragment(containerId, caseId, adHocName, data);
    }

    public List<ProcessDefinitionSummary> getProcessDefinitions(String containerId) {
        List processDefinitions = this.client.findProcessesByContainerId(containerId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return processDefinitions.stream().map(new ProcessDefinitionMapper()).collect(Collectors.toList());
    }
}

