/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import javax.interceptor.InvocationContext;
import org.jbpm.workbench.cm.backend.server.KieServerExceptionInterceptor;
import org.jbpm.workbench.cm.util.KieServerException;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.client.KieServicesHttpException;
import org.mockito.Mockito;

public class KieServerExceptionInterceptorTest {
    private KieServerExceptionInterceptor interceptor = new KieServerExceptionInterceptor();

    @Test
    public void testKieServerException() throws Exception {
        InvocationContext ctx = (InvocationContext)Mockito.mock(InvocationContext.class);
        String message = "message";
        String responseBody = "responseBody";
        Integer httpCode = 400;
        String url = "/url";
        ((InvocationContext)Mockito.doThrow((Throwable)new KieServicesHttpException("message", httpCode, "/url", "responseBody")).when((Object)ctx)).proceed();
        try {
            this.interceptor.handleKieServerException(ctx);
        }
        catch (KieServerException ex) {
            Assert.assertEquals((Object)"responseBody", (Object)ex.getMessage());
            Assert.assertEquals((Object)"/url", (Object)ex.getUrl());
            Assert.assertEquals((Object)httpCode, (Object)ex.getHttpCode());
        }
        ((InvocationContext)Mockito.verify((Object)ctx)).proceed();
    }

    @Test
    public void testRuntimeException() throws Exception {
        InvocationContext ctx = (InvocationContext)Mockito.mock(InvocationContext.class);
        String message = "message";
        ((InvocationContext)Mockito.doThrow((Throwable)new RuntimeException("message")).when((Object)ctx)).proceed();
        try {
            this.interceptor.handleKieServerException(ctx);
        }
        catch (Exception ex) {
            Assert.assertFalse((boolean)(ex instanceof KieServerException));
            Assert.assertEquals((Object)"message", (Object)ex.getMessage());
        }
        ((InvocationContext)Mockito.verify((Object)ctx)).proceed();
    }
}

