/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import com.google.common.base.Strings;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jbpm.workbench.cm.backend.server.KieServerExceptionHandler;
import org.jbpm.workbench.cm.util.KieServerException;
import org.kie.server.client.KieServicesHttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KieServerExceptionHandler
@Priority(value=2000)
@Interceptor
public class KieServerExceptionInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerExceptionInterceptor.class);

    private static String getMessage(KieServicesHttpException response) {
        return Strings.isNullOrEmpty((String)response.getResponseBody()) ? response.getMessage() : response.getResponseBody();
    }

    @AroundInvoke
    public Object handleKieServerException(InvocationContext ctx) throws Exception {
        try {
            return ctx.proceed();
        }
        catch (KieServicesHttpException ktex) {
            LOGGER.error(ktex.getMessage(), (Throwable)ktex);
            throw new KieServerException(KieServerExceptionInterceptor.getMessage(ktex), ktex.getHttpCode(), ktex.getUrl());
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

