/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import java.util.Collections;
import org.jbpm.workbench.cm.backend.server.CaseDefinitionMapper;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.cases.CaseDefinition;

public class CaseDefinitionMapperTest {
    public static void assertCaseDefinition(CaseDefinition cd, CaseDefinitionSummary cds) {
        Assert.assertNotNull((Object)cds);
        Assert.assertEquals((Object)cd.getName(), (Object)cds.getName());
        Assert.assertEquals((Object)cd.getIdentifier(), (Object)cds.getId());
        Assert.assertEquals((Object)cd.getContainerId(), (Object)cds.getContainerId());
        Assert.assertEquals((Object)cd.getRoles(), (Object)cds.getRoles());
    }

    @Test
    public void testCaseDefinitionMapper_mapCaseDefinition() {
        CaseDefinition cd = new CaseDefinition();
        cd.setIdentifier("org.jbpm.case");
        cd.setName("New case");
        cd.setContainerId("org.jbpm");
        cd.setRoles(Collections.singletonMap("participant", 2));
        CaseDefinitionSummary cds = new CaseDefinitionMapper().apply(cd);
        CaseDefinitionMapperTest.assertCaseDefinition(cd, cds);
    }

    @Test
    public void testCaseDefinitionMapper_mapNull() {
        CaseDefinition cd = null;
        CaseDefinitionSummary cds = new CaseDefinitionMapper().apply(cd);
        Assert.assertNull((Object)cds);
    }
}

