/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.SoftAssertions;
import org.jbpm.workbench.cm.backend.server.CaseActionMapperTest;
import org.jbpm.workbench.cm.backend.server.CaseCommentMapperTest;
import org.jbpm.workbench.cm.backend.server.CaseDefinitionMapperTest;
import org.jbpm.workbench.cm.backend.server.CaseInstanceMapperTest;
import org.jbpm.workbench.cm.backend.server.RemoteCaseManagementServiceImpl;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseCommentSummary;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseMilestoneSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.predicate.HumanTaskNodePredicate;
import org.jbpm.workbench.cm.predicate.MilestoneNodePredicate;
import org.jbpm.workbench.cm.util.Actions;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;
import org.jbpm.workbench.cm.util.CaseInstanceSortBy;
import org.jbpm.workbench.cm.util.CaseMilestoneSearchRequest;
import org.jbpm.workbench.cm.util.CaseStageStatus;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.cases.CaseComment;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.api.model.cases.CaseStage;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteCaseManagementServiceImplTest {
    private final String containerId = "containerId";
    private final String caseDefinitionId = "caseDefinitionId";
    private final String caseId = "CASE-1";
    private final String caseName = "case name";
    private final String caseDescription = "case description";
    private final String author = "author";
    private final String text = "text";
    private final String commentId = "commentId";
    private final String userId = "userId";
    @Mock
    private CaseServicesClient clientMock;
    @Mock
    private UserTaskServicesClient userTaskServicesClient;
    @Spy
    @InjectMocks
    private RemoteCaseManagementServiceImpl testedService;

    @Test
    public void testGetCaseDefinitions_singleCaseDefinition() {
        CaseDefinition definition = this.createTestDefinition();
        Mockito.when((Object)this.clientMock.getCaseDefinitions(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()), (String)Matchers.eq((Object)"CaseName"), Matchers.eq((boolean)true))).thenReturn(Collections.singletonList(definition));
        List definitions = this.testedService.getCaseDefinitions();
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((long)1L, (long)definitions.size());
        CaseDefinitionMapperTest.assertCaseDefinition(definition, (CaseDefinitionSummary)definitions.get(0));
    }

    @Test
    public void testGetCaseDefinitions_emptyList() {
        Mockito.when((Object)this.clientMock.getCaseDefinitions(Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.emptyList());
        List definitions = this.testedService.getCaseDefinitions();
        Assert.assertNotNull((Object)definitions);
        Assert.assertTrue((boolean)definitions.isEmpty());
    }

    @Test
    public void getCaseDefinition_whenClientReturnsCaseDefinition() {
        CaseDefinition definition = this.createTestDefinition();
        Mockito.when((Object)this.clientMock.getCaseDefinition(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)definition);
        CaseDefinitionSummary actualDef = this.testedService.getCaseDefinition("containerId", "caseDefinitionId");
        CaseDefinitionMapperTest.assertCaseDefinition(definition, actualDef);
    }

    @Test
    public void getCaseDefinition_whenClientReturnsNull() {
        Mockito.when((Object)this.clientMock.getCaseDefinition(Matchers.anyString(), Matchers.anyString())).thenReturn(null);
        CaseDefinitionSummary shouldBeNull = this.testedService.getCaseDefinition("containerId", "caseDefinitionId");
        Assert.assertNull((Object)shouldBeNull);
    }

    @Test
    public void getCaseInstances_singleCaseInstance() {
        CaseInstanceSearchRequest request = new CaseInstanceSearchRequest();
        CaseInstance instance = this.createTestInstance("CASE-1");
        Mockito.when((Object)this.clientMock.getCaseInstances((List)Matchers.eq(Collections.singletonList(request.getStatus().getName())), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.singletonList(instance));
        List instances = this.testedService.getCaseInstances(request);
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        CaseInstanceMapperTest.assertCaseInstance(instance, (CaseInstanceSummary)instances.get(0));
    }

    @Test
    public void getCaseInstances_emptyList() {
        CaseInstanceSearchRequest request = new CaseInstanceSearchRequest();
        Mockito.when((Object)this.clientMock.getCaseInstances((List)Matchers.eq(Collections.singletonList(request.getStatus().getName())), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Collections.emptyList());
        List instances = this.testedService.getCaseInstances(request);
        Assert.assertNotNull((Object)instances);
        Assert.assertTrue((boolean)instances.isEmpty());
    }

    @Test
    public void getCaseInstances_sortCaseInstanceList() {
        CaseInstance c1 = this.createTestInstance("id1");
        c1.setStartedAt(new Date(10000L));
        CaseInstance c2 = this.createTestInstance("id2");
        c2.setStartedAt(new Date(10L));
        Mockito.when((Object)this.clientMock.getCaseInstances(Matchers.anyList(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(c1, c2));
        CaseInstanceSearchRequest defaultSortRequest = new CaseInstanceSearchRequest();
        List sortedInstances = this.testedService.getCaseInstances(defaultSortRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        CaseInstanceSearchRequest sortByIdRequest = new CaseInstanceSearchRequest();
        sortByIdRequest.setSortBy(CaseInstanceSortBy.CASE_ID);
        sortByIdRequest.setSortByAsc(Boolean.valueOf(true));
        sortedInstances = this.testedService.getCaseInstances(sortByIdRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        sortByIdRequest.setSortByAsc(Boolean.valueOf(false));
        sortedInstances = this.testedService.getCaseInstances(sortByIdRequest);
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        CaseInstanceSearchRequest sortByStarted = new CaseInstanceSearchRequest();
        sortByStarted.setSortBy(CaseInstanceSortBy.START_TIME);
        sortByStarted.setSortByAsc(Boolean.valueOf(true));
        sortedInstances = this.testedService.getCaseInstances(sortByStarted);
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
        sortByStarted.setSortByAsc(Boolean.valueOf(false));
        sortedInstances = this.testedService.getCaseInstances(sortByStarted);
        Assert.assertEquals((Object)"id1", (Object)((CaseInstanceSummary)sortedInstances.get(0)).getCaseId());
        Assert.assertEquals((Object)"id2", (Object)((CaseInstanceSummary)sortedInstances.get(1)).getCaseId());
    }

    @Test
    public void testStartCaseInstance() {
        String owner = "userx";
        String role = "test";
        String user = "user1";
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).build());
        this.testedService.startCaseInstance("containerId", "caseDefinitionId", "userx", roles);
        ArgumentCaptor caseFileCaptor = ArgumentCaptor.forClass(CaseFile.class);
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).startCase((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"caseDefinitionId"), (CaseFile)caseFileCaptor.capture());
        CaseFile caseFile = (CaseFile)caseFileCaptor.getValue();
        Assert.assertEquals((Object)"userx", caseFile.getUserAssignments().get("owner"));
        Assert.assertEquals((Object)"user1", caseFile.getUserAssignments().get("test"));
    }

    @Test
    public void testCancelCaseInstance() {
        this.testedService.cancelCaseInstance("containerId", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).cancelCaseInstance("containerId", "CASE-1");
    }

    @Test
    public void testCloseCaseInstance() {
        this.testedService.closeCaseInstance("containerId", "CASE-1", null);
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).closeCaseInstance("containerId", "CASE-1", null);
    }

    @Test
    public void getCaseInstance_whenClientReturnsInstance() {
        CaseInstance ci = this.createTestInstance("CASE-1");
        Mockito.when((Object)this.clientMock.getCaseInstance(ci.getContainerId(), ci.getCaseId(), false, true, true, true)).thenReturn((Object)ci);
        CaseInstanceSummary cis = this.testedService.getCaseInstance(ci.getContainerId(), ci.getCaseId());
        CaseInstanceMapperTest.assertCaseInstance(ci, cis);
    }

    @Test
    public void getCaseInstance_whenClientReturnsNull() {
        Mockito.when((Object)this.clientMock.getCaseInstance("containerId", "CASE-1", false, true, true, true)).thenReturn(null);
        CaseInstanceSummary cis = this.testedService.getCaseInstance("containerId", "CASE-1");
        Assert.assertNull((Object)cis);
    }

    @Test
    public void testGetComments_singleComment() {
        CaseComment caseComment = this.createTestComment();
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(10))).thenReturn(Collections.singletonList(caseComment));
        List comments = this.testedService.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)1L, (long)comments.size());
        CaseCommentMapperTest.assertCaseComment(caseComment, (CaseCommentSummary)comments.get(0));
    }

    @Test
    public void testGetComments_bulkComments() {
        int pageSize = 20;
        ArrayList<CaseComment> caseComments = new ArrayList<CaseComment>();
        for (int i = 0; i < 55; ++i) {
            CaseComment caseComment = this.createTestComment();
            caseComments.add(caseComment);
        }
        List firstPage = caseComments.subList(0, 20);
        List secondPage = caseComments.subList(20, 40);
        List thirdPage = caseComments.subList(40, 55);
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(20))).thenReturn(firstPage);
        List comments = this.testedService.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(pageSize));
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)20L, (long)comments.size());
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(1), Integer.valueOf(20))).thenReturn(secondPage);
        comments = this.testedService.getComments("containerId", "CASE-1", Integer.valueOf(1), Integer.valueOf(pageSize));
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)20L, (long)comments.size());
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(2), Integer.valueOf(20))).thenReturn(thirdPage);
        comments = this.testedService.getComments("containerId", "CASE-1", Integer.valueOf(2), Integer.valueOf(pageSize));
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)15L, (long)comments.size());
    }

    @Test
    public void testGetComments_emptyList() {
        Mockito.when((Object)this.clientMock.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(0))).thenReturn(Collections.emptyList());
        List comments = this.testedService.getComments("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(10));
        Assert.assertNotNull((Object)comments);
        Assert.assertTrue((boolean)comments.isEmpty());
    }

    @Test
    public void testAddComment() {
        this.testedService.addComment("containerId", "CASE-1", "author", "text");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).addComment("containerId", "CASE-1", "author", "text");
    }

    @Test
    public void testUpdateComment() {
        this.testedService.updateComment("containerId", "CASE-1", "commentId", "author", "text");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).updateComment("containerId", "CASE-1", "commentId", "author", "text");
    }

    @Test
    public void testRemoveComment() {
        this.testedService.removeComment("containerId", "CASE-1", "commentId");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).removeComment("containerId", "CASE-1", "commentId");
    }

    @Test
    public void getCaseMilestones_sorting() {
        CaseMilestone c1 = this.createTestMilestone("id1", "milestone1", "Available");
        CaseMilestone c2 = this.createTestMilestone("id2", "milestone2", "Available");
        CaseMilestone c3 = this.createTestMilestone("id3", "milestone3", "Completed");
        Mockito.when((Object)this.clientMock.getMilestones(Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean(), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(c1, c2, c3));
        CaseMilestoneSearchRequest defaultSortRequest = new CaseMilestoneSearchRequest();
        List sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", defaultSortRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
        CaseMilestoneSearchRequest sortByNameAscRequest = new CaseMilestoneSearchRequest();
        sortByNameAscRequest.setSortByAsc(Boolean.valueOf(true));
        sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", sortByNameAscRequest);
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
        CaseMilestoneSearchRequest sortByNameDescRequest = new CaseMilestoneSearchRequest();
        sortByNameDescRequest.setSortByAsc(Boolean.valueOf(false));
        sortedMilestones = this.testedService.getCaseMilestones("containerId", "caseId", sortByNameDescRequest);
        Assert.assertEquals((Object)"id2", (Object)((CaseMilestoneSummary)sortedMilestones.get(0)).getIdentifier());
        Assert.assertEquals((Object)"id1", (Object)((CaseMilestoneSummary)sortedMilestones.get(1)).getIdentifier());
        Assert.assertEquals((Object)"id3", (Object)((CaseMilestoneSummary)sortedMilestones.get(2)).getIdentifier());
    }

    @Test
    public void testGetCaseStages() {
        CaseStage stage1 = this.createTestCaseStage("stage1", "stage1-name", CaseStageStatus.COMPLETED.getStatus());
        CaseStage stage2 = this.createTestCaseStage("stage2", "stage2-name", CaseStageStatus.ACTIVE.getStatus());
        List<CaseStage> caseStages = Arrays.asList(stage1, stage2);
        Mockito.when((Object)this.clientMock.getStages((String)Mockito.any(), (String)Mockito.any(), Matchers.eq((boolean)false), (Integer)Mockito.any(), (Integer)Mockito.any())).thenReturn(caseStages);
        List stages = this.testedService.getCaseStages("containerId", "caseId");
        Assert.assertNotNull((Object)stages);
        Assert.assertEquals((long)2L, (long)stages.size());
        CaseInstanceMapperTest.assertCaseStages(caseStages, stages);
    }

    private CaseDefinition createTestDefinition() {
        CaseDefinition definition = CaseDefinition.builder().id("caseDefinitionId").name("case name").containerId("containerId").roles(Collections.emptyMap()).build();
        return definition;
    }

    private CaseInstance createTestInstance(String caseId) {
        CaseInstance instance = CaseInstance.builder().caseDescription("case description").caseId(caseId).caseStatus(Integer.valueOf(1)).containerId("containerId").build();
        return instance;
    }

    private CaseComment createTestComment() {
        CaseComment comment = CaseComment.builder().id("commentId").author("author").text("text").addedAt(new Date()).build();
        return comment;
    }

    private CaseMilestone createTestMilestone(String caseMilestoneId, String caseMilestoneName, String status) {
        CaseMilestone milestone = CaseMilestone.builder().name(caseMilestoneName).status(status).id(caseMilestoneId).achieved(false).build();
        return milestone;
    }

    private CaseAdHocFragment createTestCaseAdHocFragment(String name, String type) {
        CaseAdHocFragment caseAdHocFragment = CaseAdHocFragment.builder().name(name).type(type).build();
        return caseAdHocFragment;
    }

    private NodeInstance createTestNodeInstance(String name, String nodeType, Long workItemId) {
        NodeInstance nodeInstance = NodeInstance.builder().name(name).nodeType(nodeType).workItemId(workItemId).date(new Date()).build();
        return nodeInstance;
    }

    private CaseStage createTestCaseStage(String stageId, String stageName, String stageStatus) {
        CaseStage stage = CaseStage.builder().id(stageId).name(stageName).status(stageStatus).build();
        return stage;
    }

    @Test
    public void getCaseActionsTest() {
        Long nodeWorkItemId;
        CaseInstance ci = this.createTestInstance("CASE-1");
        CaseStage stage1 = this.createTestCaseStage("stage1", "stage1-name", CaseStageStatus.ACTIVE.getStatus());
        CaseAdHocFragment cAHF1_stage1 = this.createTestCaseAdHocFragment("stage1-adHoc-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2_stage1 = this.createTestCaseAdHocFragment("stage1-adHoc-2", "adHocFragment-type-2");
        CaseStage stage2 = this.createTestCaseStage("stage2", "stage2-name", CaseStageStatus.COMPLETED.getStatus());
        CaseAdHocFragment cAHF1_stage2 = this.createTestCaseAdHocFragment("stage2-adHoc-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2_stage2 = this.createTestCaseAdHocFragment("stage2-adHoc-2", "adHocFragment-type-2");
        stage1.setAdHocFragments(Arrays.asList(cAHF1_stage1, cAHF2_stage1));
        stage2.setAdHocFragments(Arrays.asList(cAHF1_stage2, cAHF2_stage2));
        ci.setStages(Arrays.asList(stage1, stage2));
        Mockito.when((Object)this.clientMock.getCaseInstance(ci.getContainerId(), ci.getCaseId(), false, true, true, true)).thenReturn((Object)ci);
        CaseAdHocFragment cAHF1 = this.createTestCaseAdHocFragment("adHocFragment-name-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2 = this.createTestCaseAdHocFragment("adHocFragment-name-2", "adHocFragment-type-2");
        CaseAdHocFragment cAHF3 = this.createTestCaseAdHocFragment("active1", "Human Task");
        CaseAdHocFragment cAHF4 = this.createTestCaseAdHocFragment("active2", "HumanTaskNode");
        CaseAdHocFragment cAHF5 = this.createTestCaseAdHocFragment("Milestone 1", "MilestoneNode");
        CaseAdHocFragment cAHF6 = this.createTestCaseAdHocFragment("Milestone 2", "MilestoneNode");
        Mockito.when((Object)this.clientMock.getAdHocFragments("containerId", "CASE-1")).thenReturn(Arrays.asList(cAHF1, cAHF2, cAHF3, cAHF4, cAHF5, cAHF6));
        Long l = nodeWorkItemId = Long.valueOf(0L);
        Long l2 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node1 = this.createTestNodeInstance("active1", "Human Task", l);
        l2 = nodeWorkItemId;
        Long l3 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node2 = this.createTestNodeInstance("active2", "Service Task", l2);
        l3 = nodeWorkItemId;
        Long l4 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node3 = this.createTestNodeInstance("active2", "HumanTaskNode", l3);
        l4 = nodeWorkItemId;
        Long l5 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node4 = this.createTestNodeInstance("Milestone 1", "MilestoneNode", l4);
        Mockito.when((Object)this.clientMock.getActiveNodes((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"CASE-1"), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(node1, node2, node3, node4));
        l5 = nodeWorkItemId;
        Long l6 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node5 = this.createTestNodeInstance("complete1", "Human Task", l5);
        l6 = nodeWorkItemId;
        Long l7 = nodeWorkItemId = Long.valueOf(nodeWorkItemId + 1L);
        NodeInstance node6 = this.createTestNodeInstance("complete2", "Service Task", l6);
        Mockito.when((Object)this.clientMock.getCompletedNodes((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"CASE-1"), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(node5, node6));
        TaskInstance t1 = TaskInstance.builder().actualOwner("Koe").build();
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId(node1.getWorkItemId())).thenReturn((Object)t1);
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId(node3.getWorkItemId())).thenReturn((Object)t1);
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId(node5.getWorkItemId())).thenReturn((Object)t1);
        Actions actions = this.testedService.getCaseActions("containerId", "CASE-1", "userId");
        Assert.assertEquals((long)5L, (long)actions.getAvailableActions().size());
        CaseActionMapperTest.assertCaseActionAdHocFragment(cAHF1, (CaseActionSummary)actions.getAvailableActions().get(0));
        CaseActionMapperTest.assertCaseActionAdHocFragment(cAHF2, (CaseActionSummary)actions.getAvailableActions().get(1));
        CaseActionMapperTest.assertCaseActionAdHocFragment(cAHF6, (CaseActionSummary)actions.getAvailableActions().get(2));
        CaseActionMapperTest.assertCaseActionAdHocFragmentWithStage(cAHF1_stage1, (CaseActionSummary)actions.getAvailableActions().get(3));
        CaseActionMapperTest.assertCaseActionAdHocFragmentWithStage(cAHF2_stage1, (CaseActionSummary)actions.getAvailableActions().get(4));
        Assert.assertEquals((long)4L, (long)actions.getInProgressAction().size());
        CaseActionMapperTest.assertCaseActionNodeInstance(node1, (CaseActionSummary)actions.getInProgressAction().get(0));
        CaseActionMapperTest.assertCaseActionNodeInstance(node2, (CaseActionSummary)actions.getInProgressAction().get(1));
        CaseActionMapperTest.assertCaseActionNodeInstance(node3, (CaseActionSummary)actions.getInProgressAction().get(2));
        CaseActionMapperTest.assertCaseActionNodeInstance(node4, (CaseActionSummary)actions.getInProgressAction().get(3));
        Assert.assertEquals((long)2L, (long)actions.getCompleteActions().size());
        CaseActionMapperTest.assertCaseActionNodeInstance(node5, (CaseActionSummary)actions.getCompleteActions().get(0));
        CaseActionMapperTest.assertCaseActionNodeInstance(node6, (CaseActionSummary)actions.getCompleteActions().get(1));
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).getAdHocFragments("containerId", "CASE-1");
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).getActiveNodes((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"CASE-1"), Integer.valueOf(Matchers.eq((int)0)), Integer.valueOf(Matchers.anyInt()));
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).getCompletedNodes((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"CASE-1"), Integer.valueOf(Matchers.eq((int)0)), Integer.valueOf(Matchers.anyInt()));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(node1.getWorkItemId());
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).findTaskByWorkItemId(node2.getWorkItemId());
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(node3.getWorkItemId());
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).findTaskByWorkItemId(node4.getWorkItemId());
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(node5.getWorkItemId());
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).findTaskByWorkItemId(node6.getWorkItemId());
    }

    @Test
    public void getInProgressActionsTest() {
        Long node1WorkItemId = 1L;
        Long node2WorkItemId = 2L;
        String taskActualOwner = "Owner";
        NodeInstance node1 = this.createTestNodeInstance("active1", "Human Task", node1WorkItemId);
        NodeInstance node2 = this.createTestNodeInstance("active2", "Service Task", node2WorkItemId);
        TaskInstance t1 = TaskInstance.builder().actualOwner(taskActualOwner).build();
        Mockito.when((Object)this.clientMock.getActiveNodes((String)Matchers.eq((Object)"containerId"), (String)Matchers.eq((Object)"CASE-1"), Integer.valueOf(Matchers.anyInt()), Integer.valueOf(Matchers.anyInt()))).thenReturn(Arrays.asList(node1, node2));
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId(node1WorkItemId)).thenReturn((Object)t1);
        List actionsSummaries = this.testedService.getInProgressActions("containerId", "CASE-1");
        Assert.assertEquals((long)2L, (long)actionsSummaries.size());
        Assert.assertEquals((Object)CaseActionStatus.IN_PROGRESS, (Object)((CaseActionSummary)actionsSummaries.get(0)).getActionStatus());
        Assert.assertEquals((Object)CaseActionStatus.IN_PROGRESS, (Object)((CaseActionSummary)actionsSummaries.get(1)).getActionStatus());
        Assert.assertEquals((Object)taskActualOwner, (Object)((CaseActionSummary)actionsSummaries.get(0)).getActualOwner());
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)((CaseActionSummary)actionsSummaries.get(1)).getActualOwner()));
        CaseActionMapperTest.assertCaseActionNodeInstance(node1, (CaseActionSummary)actionsSummaries.get(0));
        CaseActionMapperTest.assertCaseActionNodeInstance(node2, (CaseActionSummary)actionsSummaries.get(1));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(node1WorkItemId);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).findTaskByWorkItemId(node2WorkItemId);
    }

    @Test
    public void getAdHocActionsTest() {
        CaseInstance ci = this.createTestInstance("CASE-1");
        CaseStage stage1 = this.createTestCaseStage("stage1", "stage1-name", CaseStageStatus.ACTIVE.getStatus());
        CaseAdHocFragment cAHF1_stage1 = this.createTestCaseAdHocFragment("stage1-adHoc-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2_stage1 = this.createTestCaseAdHocFragment("stage1-adHoc-2", "adHocFragment-type-2");
        CaseStage stage2 = this.createTestCaseStage("stage2", "stage2-name", CaseStageStatus.COMPLETED.getStatus());
        CaseAdHocFragment cAHF1_stage2 = this.createTestCaseAdHocFragment("stage2-adHoc-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2_stage2 = this.createTestCaseAdHocFragment("stage2-adHoc-2", "adHocFragment-type-2");
        stage1.setAdHocFragments(Arrays.asList(cAHF1_stage1, cAHF2_stage1));
        stage2.setAdHocFragments(Arrays.asList(cAHF1_stage2, cAHF2_stage2));
        ci.setStages(Arrays.asList(stage1, stage2));
        Mockito.when((Object)this.clientMock.getCaseInstance(ci.getContainerId(), ci.getCaseId(), false, true, true, true)).thenReturn((Object)ci);
        CaseAdHocFragment cAHF1 = this.createTestCaseAdHocFragment("adHocFragment-name-1", "adHocFragment-type-1");
        CaseAdHocFragment cAHF2 = this.createTestCaseAdHocFragment("adHocFragment-name-2", "adHocFragment-type-2");
        Mockito.when((Object)this.clientMock.getAdHocFragments("containerId", "CASE-1")).thenReturn(Arrays.asList(cAHF1, cAHF2));
        List ahdocActions = this.testedService.getAdHocActions("containerId", "CASE-1");
        Assert.assertEquals((long)4L, (long)ahdocActions.size());
        CaseActionMapperTest.assertCaseActionAdHocFragment(cAHF1, (CaseActionSummary)ahdocActions.get(0));
        CaseActionMapperTest.assertCaseActionAdHocFragment(cAHF2, (CaseActionSummary)ahdocActions.get(1));
        CaseActionMapperTest.assertCaseActionAdHocFragmentWithStage(cAHF1_stage1, (CaseActionSummary)ahdocActions.get(2));
        CaseActionMapperTest.assertCaseActionAdHocFragmentWithStage(cAHF2_stage1, (CaseActionSummary)ahdocActions.get(3));
        ((CaseServicesClient)Mockito.verify((Object)this.clientMock)).getAdHocFragments("containerId", "CASE-1");
    }

    @Test
    public void getCompletedActionsTest_withUserTasks() {
        NodeInstance nodeInstance = this.createTestNodeInstance("completedNode", "HumanTaskNode", 1L);
        TaskInstance taskInstance = TaskInstance.builder().actualOwner("owner").build();
        Mockito.when((Object)this.clientMock.getCompletedNodes("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(Collections.singletonList(nodeInstance));
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId(nodeInstance.getWorkItemId())).thenReturn((Object)taskInstance);
        List result = this.testedService.getCompletedActions("containerId", "CASE-1");
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(((CaseActionSummary)result.get(0)).getName()).isEqualTo(nodeInstance.getName());
            softly.assertThat(((CaseActionSummary)result.get(0)).getType()).isEqualTo(nodeInstance.getNodeType());
            softly.assertThat(((CaseActionSummary)result.get(0)).getActualOwner()).isEqualTo(taskInstance.getActualOwner());
            softly.assertThat((Comparable)((CaseActionSummary)result.get(0)).getActionStatus()).isEqualTo((Object)CaseActionStatus.COMPLETED);
        });
    }

    @Test
    public void getCompletedActionsTest_withoutUserTasks() {
        NodeInstance nodeInstance = this.createTestNodeInstance("completedNode", "Service Task", 1L);
        Mockito.when((Object)this.clientMock.getCompletedNodes("containerId", "CASE-1", Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE))).thenReturn(Collections.singletonList(nodeInstance));
        List result = this.testedService.getCompletedActions("containerId", "CASE-1");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.userTaskServicesClient});
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(((CaseActionSummary)result.get(0)).getName()).isEqualTo(nodeInstance.getName());
            softly.assertThat(((CaseActionSummary)result.get(0)).getType()).isEqualTo(nodeInstance.getNodeType());
            softly.assertThat(((CaseActionSummary)result.get(0)).getActualOwner()).isEmpty();
            softly.assertThat((Comparable)((CaseActionSummary)result.get(0)).getActionStatus()).isEqualTo((Object)CaseActionStatus.COMPLETED);
        });
    }

    @Test
    public void testMilestoneNodePredicate() {
        Assert.assertFalse((boolean)new MilestoneNodePredicate().test(CaseActionSummary.builder().type("HumanTaskNode").build().getType()));
        Assert.assertTrue((boolean)new MilestoneNodePredicate().test(CaseActionSummary.builder().type("MilestoneNode").build().getType()));
    }

    @Test
    public void testHumanTaskNodePredicate() {
        String taskName = "Task Name";
        List<CaseActionSummary> actions = Arrays.asList(CaseActionSummary.builder().type((String)HumanTaskNodePredicate.NODE_TYPE_LIST_HUMAN_TASK.get(0)).name("Task Name").build(), CaseActionSummary.builder().type((String)HumanTaskNodePredicate.NODE_TYPE_LIST_HUMAN_TASK.get(1)).name("Task Name").build());
        Assert.assertTrue((boolean)new RemoteCaseManagementServiceImpl.InProgressHumanTaskPredicate().test(CaseActionSummary.builder().type((String)HumanTaskNodePredicate.NODE_TYPE_LIST_HUMAN_TASK.get(0)).name("Task Name").build(), actions));
        Assert.assertTrue((boolean)new RemoteCaseManagementServiceImpl.InProgressHumanTaskPredicate().test(CaseActionSummary.builder().type((String)HumanTaskNodePredicate.NODE_TYPE_LIST_HUMAN_TASK.get(1)).name("Task Name").build(), actions));
        Assert.assertFalse((boolean)new RemoteCaseManagementServiceImpl.InProgressHumanTaskPredicate().test(CaseActionSummary.builder().type((String)HumanTaskNodePredicate.NODE_TYPE_LIST_HUMAN_TASK.get(0)).name("Task Name 2").build(), actions));
        Assert.assertFalse((boolean)new RemoteCaseManagementServiceImpl.InProgressHumanTaskPredicate().test(CaseActionSummary.builder().type("MilestoneNode").name("Task Name").build(), actions));
    }
}

