/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.backend.server;

import java.util.Date;
import org.jbpm.workbench.cm.backend.server.CaseActionAdHocMapper;
import org.jbpm.workbench.cm.backend.server.CaseActionNodeInstanceMapper;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.instance.NodeInstance;

public class CaseActionMapperTest {
    private static final String STAGE_ID = "StageId";
    private static final String HUMAN_TASK_OWNER = "humanTaskOwner";

    public static void assertCaseActionAdHocFragment(CaseAdHocFragment cc, CaseActionSummary ccs) {
        Assert.assertNotNull((Object)ccs);
        Assert.assertNotNull((Object)cc);
        Assert.assertEquals((Object)cc.getName(), (Object)ccs.getName());
        Assert.assertEquals((Object)cc.getType(), (Object)ccs.getType());
        Assert.assertNotNull((Object)ccs.getStageId());
        Assert.assertEquals((Object)CaseActionType.AD_HOC_TASK, (Object)ccs.getActionType());
        Assert.assertEquals((Object)CaseActionStatus.AVAILABLE, (Object)ccs.getActionStatus());
    }

    public static void assertCaseActionNodeInstance(NodeInstance nodeInstance, CaseActionSummary caseActionSummary) {
        Assert.assertNotNull((Object)caseActionSummary);
        Assert.assertNotNull((Object)nodeInstance);
        Assert.assertEquals((Object)nodeInstance.getId(), (Object)caseActionSummary.getId());
        Assert.assertEquals((Object)nodeInstance.getName(), (Object)caseActionSummary.getName());
        Assert.assertEquals((Object)nodeInstance.getNodeType(), (Object)caseActionSummary.getType());
        Assert.assertEquals((Object)nodeInstance.getDate(), (Object)caseActionSummary.getCreatedOn());
        Assert.assertNotNull((Object)caseActionSummary.getActionStatus());
    }

    @Test
    public void testCaseActionAdHocFragmentMapper_mapCaseAction() {
        CaseAdHocFragment cc = CaseAdHocFragment.builder().name("AdhocFragment-name").type("AdhocFragment-type").build();
        CaseActionSummary ccs = new CaseActionAdHocMapper(STAGE_ID).apply(cc);
        CaseActionMapperTest.assertCaseActionAdHocFragment(cc, ccs);
    }

    @Test
    public void testCaseActionAdHocFragmentMapper_mapNull() {
        CaseAdHocFragment cc = null;
        CaseActionSummary ccs = new CaseActionAdHocMapper(STAGE_ID).apply(cc);
        Assert.assertNull((Object)ccs);
    }

    @Test
    public void testCaseActionNodeInstanceMapper_mapCaseAction() {
        NodeInstance nodeInstance = NodeInstance.builder().name("NodeInst-name").nodeType("NodeInst-type").date(new Date()).build();
        CaseActionSummary caseActionSummary = new CaseActionNodeInstanceMapper(HUMAN_TASK_OWNER, CaseActionStatus.IN_PROGRESS).apply(nodeInstance);
        CaseActionMapperTest.assertCaseActionNodeInstance(nodeInstance, caseActionSummary);
        Assert.assertEquals((Object)HUMAN_TASK_OWNER, (Object)caseActionSummary.getActualOwner());
        Assert.assertEquals((Object)CaseActionStatus.IN_PROGRESS, (Object)caseActionSummary.getActionStatus());
    }

    @Test
    public void testCaseActionNodeInstanceMapper_mapNull() {
        NodeInstance nodeInstance = null;
        CaseActionSummary ccs = new CaseActionNodeInstanceMapper(HUMAN_TASK_OWNER, CaseActionStatus.IN_PROGRESS).apply(nodeInstance);
        Assert.assertNull((Object)ccs);
    }
}

