/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.server;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Specializes;
import org.jbpm.workbench.cm.backend.server.RemoteCaseManagementServiceImpl;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseCommentSummary;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseMilestoneSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.model.CaseStageSummary;
import org.jbpm.workbench.cm.model.ProcessDefinitionSummary;
import org.jbpm.workbench.cm.util.CaseActionStatus;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;
import org.jbpm.workbench.cm.util.CaseMilestoneSearchRequest;
import org.jbpm.workbench.cm.util.CaseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Specializes
public class MockCaseManagementService
extends RemoteCaseManagementServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockCaseManagementService.class);
    private static final String CASE_DEFINITIONS_JSON = "case_definitions.json";
    private static final String CASE_MILESTONES_JSON = "case_milestones.json";
    private static final String CASE_COMMENTS_JSON = "case_comments.json";
    private static final String CASE_STAGES_JSON = "case_stages.json";
    private static final String CASE_ACTIONS_JSON = "case_actions.json";
    private static final String PROCESS_DEFINITION_JSON = "process_definitions.json";
    private static int commentIdGenerator = 0;
    private static long actionIdGenerator = 9L;
    private final ObjectMapper mapper = new ObjectMapper();
    private List<CaseDefinitionSummary> caseDefinitionList = Collections.emptyList();
    private List<CaseInstanceSummary> caseInstanceList = new ArrayList();
    private List<CaseStageSummary> caseStageList = new ArrayList();
    private Map<String, List<CaseCommentSummary>> caseCommentMap = new HashMap();
    private List<CaseMilestoneSummary> caseMilestoneList = new ArrayList();
    private List<CaseCommentSummary> caseCommentList = new ArrayList();
    private Map<String, List<CaseActionSummary>> caseActionMap = new HashMap();
    private List<CaseActionSummary> caseActionList = new ArrayList();
    private List<ProcessDefinitionSummary> processDefinitionList = Collections.emptyList();

    @PostConstruct
    public void init() {
        this.caseDefinitionList = this.readJsonValues(CaseDefinitionSummary.class, CASE_DEFINITIONS_JSON);
        this.caseMilestoneList = this.readJsonValues(CaseMilestoneSummary.class, CASE_MILESTONES_JSON);
        this.caseCommentList = this.readJsonValues(CaseCommentSummary.class, CASE_COMMENTS_JSON);
        this.caseStageList = this.readJsonValues(CaseStageSummary.class, CASE_STAGES_JSON);
        this.caseActionList = this.readJsonValues(CaseActionSummary.class, CASE_ACTIONS_JSON);
        this.processDefinitionList = this.readJsonValues(ProcessDefinitionSummary.class, PROCESS_DEFINITION_JSON);
        LOGGER.info("Loaded {} case definitions", (Object)this.caseDefinitionList.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> List<T> readJsonValues(Class<T> type, String fileName) {
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            CollectionType collectionType = this.mapper.getTypeFactory().constructCollectionType(List.class, type);
            List list = (List)this.mapper.readValue(inputStream, (JavaType)collectionType);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load json data file", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public CaseDefinitionSummary getCaseDefinition(String serverTemplateId, String containerId, String caseDefinitionId) {
        return this.caseDefinitionList.stream().filter(c -> c.getId().equals(caseDefinitionId)).findFirst().get();
    }

    public List<CaseDefinitionSummary> getCaseDefinitions() {
        return this.caseDefinitionList;
    }

    public String startCaseInstance(String serverTemplateId, String containerId, String caseDefinitionId, String owner, List<CaseRoleAssignmentSummary> roleAssignments) {
        CaseInstanceSummary ci = CaseInstanceSummary.builder().caseId("CASE-" + Strings.padStart((String)String.valueOf(this.caseInstanceList.size() + 1), (int)5, (char)'0')).owner(owner).startedAt(new Date()).caseDefinitionId(caseDefinitionId).status(CaseStatus.OPEN).description("New case instance for development").containerId(containerId).stages(this.caseStageList).roleAssignments(roleAssignments).build();
        this.caseInstanceList.add(ci);
        ArrayList actions = new ArrayList(this.caseActionList);
        this.caseActionMap.putIfAbsent(ci.getCaseId(), actions.stream().map(s -> {
            s.setCreatedOn(new Date());
            return s;
        }).collect(Collectors.toList()));
        ArrayList comments = new ArrayList(this.caseCommentList);
        this.caseCommentMap.putIfAbsent(ci.getCaseId(), comments.stream().map(s -> {
            s.setAddedAt(new Date());
            return s;
        }).collect(Collectors.toList()));
        return ci.getCaseId();
    }

    public List<CaseInstanceSummary> getCaseInstances(CaseInstanceSearchRequest request) {
        return this.caseInstanceList.stream().filter(c -> c.getStatus().equals((Object)request.getStatus())).sorted(this.getCaseInstanceSummaryComparator(request)).collect(Collectors.toList());
    }

    public CaseInstanceSummary getCaseInstance(String serverTemplateId, String containerId, String caseId) {
        return this.caseInstanceList.stream().filter(c -> c.getCaseId().equals(caseId)).findFirst().get();
    }

    public void cancelCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.executeOnCaseInstance(caseId, c -> c.setStatus(CaseStatus.CANCELLED));
    }

    public void destroyCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.executeOnCaseInstance(caseId, c -> c.setStatus(CaseStatus.CANCELLED));
    }

    public List<CaseCommentSummary> getComments(String serverTemplateId, String containerId, String caseId, Integer page, Integer pageSize) {
        List allComments = (List)this.caseCommentMap.get(caseId);
        List subList = new ArrayList();
        int allCommentsSize = allComments.size();
        int offset = page * pageSize;
        int pageIndex = (allCommentsSize + pageSize - 1) / pageSize;
        if (allCommentsSize < pageSize) {
            return allComments;
        }
        subList = pageIndex == page + 1 ? allComments.subList(offset, allCommentsSize) : allComments.subList(offset, offset + pageSize);
        return new ArrayList<CaseCommentSummary>(subList);
    }

    public void addComment(String serverTemplateId, String containerId, String caseId, String author, String text) {
        List commentSummaryList = this.caseCommentMap.getOrDefault(caseId, new ArrayList());
        String newId = String.valueOf(commentIdGenerator++);
        CaseCommentSummary caseCommentSummary = CaseCommentSummary.builder().id(newId).author(author).text(text).addedAt(new Date()).build();
        commentSummaryList.add(caseCommentSummary);
        this.caseCommentMap.putIfAbsent(caseId, commentSummaryList);
    }

    public void updateComment(String serverTemplateId, String containerId, String caseId, String commentId, String author, String text) {
        Optional.ofNullable(this.caseCommentMap.get(caseId)).ifPresent(l -> l.stream().filter(c -> c.getId().equals(commentId)).findFirst().ifPresent(c -> c.setText(text)));
    }

    public void removeComment(String serverTemplateId, String containerId, String caseId, String commentId) {
        Optional.ofNullable(this.caseCommentMap.get(caseId)).ifPresent(l -> l.stream().filter(c -> c.getId().equals(commentId)).findFirst().ifPresent(c -> l.remove(c)));
    }

    public void assignUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getUsers().add(user));
    }

    public void assignGroupToRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getGroups().add(group));
    }

    public void removeUserFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getUsers().remove(user));
    }

    public void removeGroupFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getGroups().remove(group));
    }

    private void executeOnCaseInstance(String caseId, Consumer<CaseInstanceSummary> consumer) {
        this.caseInstanceList.stream().filter(c -> c.getCaseId().equals(caseId)).findFirst().ifPresent(consumer);
    }

    private void executeOnCaseRole(String caseId, String roleName, Consumer<CaseRoleAssignmentSummary> consumer) {
        this.executeOnCaseInstance(caseId, c -> {
            CaseRoleAssignmentSummary role = c.getRoleAssignments().stream().filter(r -> r.getName().equals(roleName)).findFirst().orElseGet(() -> {
                CaseRoleAssignmentSummary newRole = CaseRoleAssignmentSummary.builder().name(roleName).build();
                c.getRoleAssignments().add(newRole);
                return newRole;
            });
            consumer.accept(role);
        });
    }

    public List<CaseMilestoneSummary> getCaseMilestones(String containerId, String caseId, CaseMilestoneSearchRequest request) {
        return this.caseMilestoneList.stream().sorted(this.getCaseMilestoneSummaryComparator(request)).collect(Collectors.toList());
    }

    public List<CaseActionSummary> getAdHocFragments(String containerId, String caseId) {
        return Optional.ofNullable(this.caseActionMap.get(caseId)).orElse(Collections.emptyList()).stream().filter(c -> CaseActionType.AD_HOC_TASK == c.getActionType()).collect(Collectors.toList());
    }

    public List<CaseActionSummary> getInProgressActions(String containerId, String caseId) {
        return Optional.ofNullable(this.caseActionMap.get(caseId)).orElse(Collections.emptyList()).stream().filter(c -> CaseActionStatus.IN_PROGRESS == c.getActionStatus()).collect(Collectors.toList());
    }

    public List<CaseActionSummary> getCompletedActions(String containerId, String caseId) {
        return Optional.ofNullable(this.caseActionMap.get(caseId)).orElse(Collections.emptyList()).stream().filter(c -> CaseActionStatus.COMPLETED == c.getActionStatus()).collect(Collectors.toList());
    }

    public void addDynamicUserTask(String containerId, String caseId, String name, String description, String actors, String groups, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name(name).actualOwner(actors).type("Human Task").actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public void addDynamicUserTaskToStage(String containerId, String caseId, String stageId, String name, String description, String actors, String groups, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name(name).actualOwner(actors).type("Human Task").actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public void triggerAdHocActionInStage(String containerId, String caseId, String stageId, String adHocName, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name(adHocName).actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public void triggerAdHocAction(String containerId, String caseId, String adHocName, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name(adHocName).actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public void addDynamicSubProcess(String containerId, String caseId, String processId, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name("subprocess: " + processId).actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public void addDynamicSubProcessToStage(String containerId, String caseId, String stageId, String processId, Map<String, Object> data) {
        List actionSummaryList = this.caseActionMap.getOrDefault(caseId, new ArrayList());
        CaseActionSummary action = CaseActionSummary.builder().id(Long.valueOf(actionIdGenerator++)).name("subprocess: " + processId + " inStage:" + stageId).actionStatus(CaseActionStatus.IN_PROGRESS).createdOn(new Date()).build();
        actionSummaryList.add(action);
        this.caseActionMap.putIfAbsent(caseId, actionSummaryList);
    }

    public List<ProcessDefinitionSummary> getProcessDefinitions(String containerId) {
        return this.processDefinitionList;
    }
}

