/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.workbench.es.backend.server.DataSetDefsBootstrap;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DataSetDefRegistry dataSetDefRegistry;
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;

    @Test
    public void testRequestListDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmRequestList").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmRequestList", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmRequestList", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)12L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testErrorListDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmExecutionErrorList").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmExecutionErrorList", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmExecutionErrorList", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)13L, (long)dataSetDef.getColumns().size());
    }
}

