/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import org.jbpm.workbench.es.backend.server.ExecutionErrorSummaryMapperTest;
import org.jbpm.workbench.es.backend.server.RemoteExecutorServiceImpl;
import org.jbpm.workbench.es.backend.server.RequestDetailsMapperTest;
import org.jbpm.workbench.es.backend.server.RequestSummaryMapperTest;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteExecutorServiceImplTest {
    @Mock
    KieServerIntegration kieServerIntegration;
    @Mock
    JobServicesClient jobServicesClient;
    @Mock
    ProcessAdminServicesClient processAdminServicesClient;
    @InjectMocks
    RemoteExecutorServiceImpl executorService;

    @Before
    public void init() {
        KieServicesClient servicesClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        Mockito.when((Object)((JobServicesClient)servicesClient.getServicesClient(JobServicesClient.class))).thenReturn((Object)this.jobServicesClient);
        Mockito.when((Object)((ProcessAdminServicesClient)servicesClient.getServicesClient(ProcessAdminServicesClient.class))).thenReturn((Object)this.processAdminServicesClient);
        Mockito.when((Object)this.kieServerIntegration.getServerClient((String)ArgumentMatchers.any())).thenReturn((Object)servicesClient);
    }

    @Test
    public void testGetRequestDetails() {
        RequestInfoInstance ri = RequestSummaryMapperTest.newRequestInfoInstance();
        Mockito.when((Object)this.jobServicesClient.getRequestById("", ri.getId(), true, true)).thenReturn((Object)ri);
        RequestDetails rd = this.executorService.getRequestDetails("", "", ri.getId());
        RequestDetailsMapperTest.assertRequestDetails(ri, rd);
    }

    @Test
    public void testGetRequestDetailsEmpty() {
        Long requestId = 1L;
        Mockito.when((Object)this.jobServicesClient.getRequestById("", requestId, true, true)).thenReturn((Object)new RequestInfoInstance());
        RequestDetails requestDetails = this.executorService.getRequestDetails("", "", requestId);
        Assert.assertNotNull((Object)requestDetails);
        Assert.assertNotNull((Object)requestDetails.getRequest());
        Assert.assertTrue((boolean)requestDetails.getErrors().isEmpty());
        Assert.assertTrue((boolean)requestDetails.getParams().isEmpty());
    }

    @Test
    public void testGetRequestDetailsNull() {
        RequestDetails requestDetails = this.executorService.getRequestDetails(null, null, null);
        Assert.assertNull((Object)requestDetails);
    }

    @Test
    public void testAcknowledgeError() {
        String serverTemplateId = "testServerTemplateId";
        String deploymentId = "testDeploymentId";
        String errorId = "errorId";
        this.executorService.acknowledgeError(serverTemplateId, deploymentId, new String[]{errorId});
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration)).getServerClient(serverTemplateId);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).acknowledgeError(deploymentId, new String[]{errorId});
    }

    @Test
    public void testGetExecutionErrorDetails() {
        ExecutionErrorInstance errorInstance = ExecutionErrorSummaryMapperTest.createTestError("1");
        String serverTemplateId = "testServerTemplateId";
        Mockito.when((Object)this.processAdminServicesClient.getError(errorInstance.getContainerId(), errorInstance.getErrorId())).thenReturn((Object)errorInstance);
        ExecutionErrorSummary errorSummary = this.executorService.getError(serverTemplateId, errorInstance.getContainerId(), errorInstance.getErrorId());
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration)).getServerClient(serverTemplateId);
        ((ProcessAdminServicesClient)Mockito.verify((Object)this.processAdminServicesClient)).getError(errorInstance.getContainerId(), errorInstance.getErrorId());
        ExecutionErrorSummaryMapperTest.assertExecutionErrorSummary(errorInstance, errorSummary);
    }
}

