/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.quicknewjob;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.IntegerBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.common.client.util.UTCTimeBox;
import org.jbpm.workbench.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.service.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class QuickNewJobPopupTest {
    private String JOB_NAME = "JOB_NAME_1";
    private String JOB_TYPE = "JOB_TYPE_1";
    private int JOB_RETRIES = 5;
    @Mock
    private CallerMock<ExecutorService> executorServices;
    @Mock
    private ExecutorService executorServicesMock;
    @Mock
    private UTCTimeBox jobDueDateTime;
    @Mock
    private TextBox jobNameText;
    @Mock
    private FormGroup jobNameControlGroup;
    @Mock
    private HelpBlock jobNameHelpInline;
    @Mock
    private IntegerBox jobRetriesNumber;
    @Mock
    private TextBox jobTypeText;
    @Mock
    private FormGroup jobTypeControlGroup;
    @Mock
    private HelpBlock jobTypeHelpInline;
    @Mock
    private HelpBlock jobDueDateHelpBlock;
    @InjectMocks
    private QuickNewJobPopup quickNewJobPopup;

    @Before
    public void setupMocks() {
        this.executorServices = new CallerMock((Object)this.executorServicesMock);
        this.quickNewJobPopup.setExecutorService(this.executorServices);
    }

    @Test
    public void jobNameIsPassedAsBusinessKeyTest() {
        ((ExecutorService)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                HashMap ctxValues = (HashMap)invocationOnMock.getArguments()[2];
                Assert.assertTrue((boolean)((String)ctxValues.get("businessKey")).equals(QuickNewJobPopupTest.this.JOB_NAME));
                Assert.assertTrue((boolean)((String)ctxValues.get("retries")).equals(String.valueOf(QuickNewJobPopupTest.this.JOB_RETRIES)));
                Assert.assertTrue((boolean)invocationOnMock.getArguments()[2].equals(QuickNewJobPopupTest.this.JOB_TYPE));
                return null;
            }
        }).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.quickNewJobPopup.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, Integer.valueOf(this.JOB_RETRIES), new ArrayList());
        ((ExecutorService)Mockito.verify((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(HashMap.class));
    }

    @Test
    public void dueTimeSetToFutureTimeTest() {
        final Long nextHalfHour = UTCDateBox.date2utc((Date)new Date(System.currentTimeMillis() + 1800000L));
        final Long nextHour = UTCDateBox.date2utc((Date)new Date(System.currentTimeMillis() + 3600000L));
        ((UTCTimeBox)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Long setTime = (Long)invocationOnMock.getArguments()[0];
                Assert.assertTrue((setTime > nextHalfHour ? 1 : 0) != 0);
                Assert.assertTrue((setTime < nextHour ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)this.jobDueDateTime)).setValue(Long.valueOf(Mockito.anyLong()));
        this.quickNewJobPopup.cleanForm();
        ((UTCTimeBox)Mockito.verify((Object)this.jobDueDateTime)).setValue(Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void emptyJobName_shouldCauseValidationError() {
        Mockito.when((Object)this.jobNameText.getText()).thenReturn((Object)"");
        boolean isValid = this.quickNewJobPopup.validateForm();
        Assert.assertFalse((String)"Form with an empty business key should be rejected", (boolean)isValid);
        ((FormGroup)Mockito.verify((Object)this.jobNameControlGroup)).setValidationState(ValidationState.ERROR);
        ((HelpBlock)Mockito.verify((Object)this.jobNameHelpInline)).setText(Constants.INSTANCE.The_Job_Must_Have_A_BusinessKey());
    }

    @Test
    public void emptyType_shouldCauseValidationError() {
        Mockito.when((Object)this.jobTypeText.getText()).thenReturn((Object)"  ");
        boolean isValid = this.quickNewJobPopup.validateForm();
        Assert.assertFalse((String)"Form with an empty type should be rejected", (boolean)isValid);
        ((FormGroup)Mockito.verify((Object)this.jobTypeControlGroup)).setValidationState(ValidationState.ERROR);
        ((HelpBlock)Mockito.verify((Object)this.jobTypeHelpInline)).setText(Constants.INSTANCE.The_Job_Must_Have_A_Type());
    }

    @Test
    public void InvalidClass_shouldCauseValidationError() {
        ((ExecutorService)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new Exception("Invalid command type");
            }
        }).when((Object)this.executorServicesMock)).scheduleRequest(Mockito.anyString(), Mockito.anyString(), (Date)Mockito.any(Date.class), (Map)Mockito.any(Map.class));
        this.quickNewJobPopup.createJob(this.JOB_NAME, new Date(), this.JOB_TYPE, Integer.valueOf(this.JOB_RETRIES), new ArrayList());
        ((FormGroup)Mockito.verify((Object)this.quickNewJobPopup.jobTypeControlGroup)).setValidationState(ValidationState.ERROR);
        ((HelpBlock)Mockito.verify((Object)this.quickNewJobPopup.jobTypeHelpInline)).setText(Constants.INSTANCE.The_Job_Must_Have_A_Valid_Type());
    }
}

