/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.base.AbstractListView;
import org.jbpm.workbench.common.client.list.base.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.base.events.SearchEvent;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.jobdetails.JobDetailsPopup;
import org.jbpm.workbench.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Requests List")
public class RequestListPresenter
extends AbstractScreenListPresenter<RequestSummary>
implements RefreshSelectorMenuBuilder.SupportsRefreshInterval {
    private Constants constants = Constants.INSTANCE;
    @Inject
    private RequestListView view;
    @Inject
    private Caller<ExecutorService> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    @Inject
    DataSetQueryHelper dataSetQueryHelper;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    private RefreshSelectorMenuBuilder refreshSelectorMenuBuilder = new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this);
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private JobDetailsPopup jobDetailsPopup;

    public RequestListPresenter() {
    }

    public RequestListPresenter(RequestListViewImpl view, Caller<ExecutorService> executorServices, DataSetQueryHelper dataSetQueryHelper, Event<RequestChangedEvent> requestChangedEvent) {
        this.view = view;
        this.executorServices = executorServices;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.requestChangedEvent = requestChangedEvent;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.RequestsListTitle();
    }

    @WorkbenchPartView
    public UberView<RequestListPresenter> getView() {
        return this.view;
    }

    public void filterGrid(FilterSettings tableSettings) {
        this.dataSetQueryHelper.setCurrentTableSettings(tableSettings);
        this.refreshGrid();
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                final FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.selectedServerTemplate);
                currentTableSettings.setTablePageSize(this.view.getListGrid().getPageSize());
                ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("timestamp");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                if (!filters.isEmpty()) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), (DataSetReadyCallback)new AbstractDataSetReadyCallback(this.errorPopup, (AbstractListView.BasicListView)this.view, currentTableSettings.getDataSet()){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null && RequestListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                            ArrayList<RequestSummary> myRequestSumaryFromDataSet = new ArrayList<RequestSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myRequestSumaryFromDataSet.add(RequestListPresenter.this.getRequestSummary(dataSet, i));
                            }
                            boolean lastPageExactCount = false;
                            if (dataSet.getRowCount() < RequestListPresenter.this.view.getListGrid().getPageSize()) {
                                lastPageExactCount = true;
                            }
                            RequestListPresenter.this.updateDataOnCallback(myRequestSumaryFromDataSet, visibleRange.getStart(), visibleRange.getStart() + myRequestSumaryFromDataSet.size(), lastPageExactCount);
                        }
                    }
                });
                this.view.hideBusyIndicator();
            }
        }
        catch (Exception e) {
            this.view.displayNotification(this.constants.ErrorRetrievingJobs(e.getMessage()));
            GWT.log((String)"Error looking up dataset with UUID [ jbpmRequestList ]");
        }
    }

    protected RequestSummary getRequestSummary(DataSet dataSet, Integer index) {
        return new RequestSummary(this.dataSetQueryHelper.getColumnLongValue(dataSet, "id", index.intValue()), this.dataSetQueryHelper.getColumnDateValue(dataSet, "timestamp", index.intValue()), this.dataSetQueryHelper.getColumnStringValue(dataSet, "status", index.intValue()), this.dataSetQueryHelper.getColumnStringValue(dataSet, "commandName", index.intValue()), this.dataSetQueryHelper.getColumnStringValue(dataSet, "message", index.intValue()), this.dataSetQueryHelper.getColumnStringValue(dataSet, "businessKey", index.intValue()), Integer.valueOf(this.dataSetQueryHelper.getColumnIntValue(dataSet, "retries", index.intValue())), Integer.valueOf(this.dataSetQueryHelper.getColumnIntValue(dataSet, "executions", index.intValue())), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processName", index.intValue()), this.dataSetQueryHelper.getColumnLongValue(dataSet, "processInstanceId", index.intValue()), this.dataSetQueryHelper.getColumnStringValue(dataSet, "processInstanceDescription", index.intValue()));
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            filters.add(FilterFactory.likeTo((String)"commandName", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            filters.add(FilterFactory.likeTo((String)"message", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            filters.add(FilterFactory.likeTo((String)"businessKey", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
        }
        return filters;
    }

    public AsyncDataProvider<RequestSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void cancelRequest(final Long requestId) {
        ((ExecutorService)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification(RequestListPresenter.this.constants.RequestCancelled(requestId));
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(this.selectedServerTemplate, requestId);
    }

    public void requeueRequest(final Long requestId) {
        ((ExecutorService)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                RequestListPresenter.this.view.displayNotification(RequestListPresenter.this.constants.RequestCancelled(requestId));
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(this.selectedServerTemplate, requestId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.constants.New_Job()).respondsWith(new Command(){

            public void execute() {
                if (RequestListPresenter.this.selectedServerTemplate == null || RequestListPresenter.this.selectedServerTemplate.trim().isEmpty()) {
                    RequestListPresenter.this.view.displayNotification(RequestListPresenter.this.constants.SelectServerTemplate());
                } else {
                    RequestListPresenter.this.quickNewJobPopup.show(RequestListPresenter.this.selectedServerTemplate);
                }
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    public void onGridPreferencesStoreLoaded() {
        this.refreshSelectorMenuBuilder.loadOptions(this.view.getRefreshValue());
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.view.applyFilterOnPresenter(this.dataSetQueryHelper.getCurrentTableSettings().getKey());
    }

    public void onUpdateRefreshInterval(boolean enableAutoRefresh, int newInterval) {
        super.onUpdateRefreshInterval(enableAutoRefresh, newInterval);
        this.view.saveRefreshValue(newInterval);
    }

    public void showJobDetails(RequestSummary job) {
        this.jobDetailsPopup.show(this.selectedServerTemplate, String.valueOf(job.getJobId()));
    }

    public static interface RequestListView
    extends AbstractListView.ListView<RequestSummary, RequestListPresenter> {
        public int getRefreshValue();

        public void saveRefreshValue(int var1);

        public void applyFilterOnPresenter(String var1);
    }
}

