/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.workbench.common.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.base.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.base.AbstractMultiGridView;
import org.jbpm.workbench.common.client.util.ButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private final Constants constants = Constants.INSTANCE;
    public static String REQUEST_LIST_PREFIX = "DS_RequestListGrid";
    public static final String COL_ID_ACTIONS = "Actions";
    private List<RequestSummary> selectedRequestSummary = new ArrayList<RequestSummary>();
    @Inject
    private DataSetEditorManager dataSetEditorManager;

    public void init(final RequestListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("id");
        bannedColumns.add("commandName");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("id");
        initColumns.add("businessKey");
        initColumns.add("commandName");
        initColumns.add(COL_ID_ACTIONS);
        final Button button = (Button)GWT.create(Button.class);
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = RequestListViewImpl.this.getValidKeyForAdditionalListGrid(REQUEST_LIST_PREFIX + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = RequestListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider(presenter.getDataProvider());
                        RequestListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                                RequestListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        RequestListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = RequestListViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                RequestListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(RequestListViewImpl.this.filterPagedTable, RequestListViewImpl.this.constants.New_JobList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(REQUEST_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void requestCreated(@Observes RequestChangedEvent event) {
        ((RequestListPresenter)this.presenter).refreshGrid();
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column jobIdColumn = this.initJobIdColumn();
        Column jobNameColumn = this.initJobNameColumn();
        Column jobTypeColumn = this.initJobTypeColumn();
        Column statusColumn = this.initStatusColumn();
        Column dueDateColumn = this.initDueDateColumn();
        Column processNameColumn = this.initProcessNameColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column processInstanceDescription = this.initProcessInstanceDescription();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(jobIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(jobNameColumn, this.constants.BusinessKey()));
        columnMetas.add(new ColumnMeta(jobTypeColumn, this.constants.Type()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(dueDateColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(processInstanceDescription, this.constants.Process_Description()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (RequestListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != RequestListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(RequestListViewImpl.this.selectedStyles);
                    RequestListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                }
            }
        });
        this.initNoActionColumnManager(extendedPagedTable);
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    private void initNoActionColumnManager(final ExtendedPagedTable extendedPagedTable) {
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<RequestSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<RequestSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<RequestSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(RequestListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!RequestListViewImpl.this.selectedRequestSummary.contains(event.getValue())) {
                            RequestListViewImpl.this.selectedRequestSummary.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            RequestListViewImpl.this.selectedRequestSummary.remove(event.getValue());
                            input.setChecked(false);
                        }
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
    }

    private Column initJobIdColumn() {
        Column<RequestSummary, Number> jobIdColumn = new Column<RequestSummary, Number>((Cell)new NumberCell()){

            public Number getValue(RequestSummary object) {
                return object.getJobId();
            }
        };
        jobIdColumn.setSortable(true);
        jobIdColumn.setDataStoreName("id");
        return jobIdColumn;
    }

    private Column initJobNameColumn() {
        Column<RequestSummary, String> jobNameColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getKey();
            }
        };
        jobNameColumn.setSortable(true);
        jobNameColumn.setDataStoreName("businessKey");
        return jobNameColumn;
    }

    private Column initJobTypeColumn() {
        Column<RequestSummary, String> jobTypeColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getCommandName();
            }
        };
        jobTypeColumn.setSortable(true);
        jobTypeColumn.setDataStoreName("commandName");
        return jobTypeColumn;
    }

    private Column initStatusColumn() {
        Column<RequestSummary, String> statusColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName("status");
        return statusColumn;
    }

    private Column initDueDateColumn() {
        Column<RequestSummary, String> dueDateColumn = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getTime());
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName("timestamp");
        return dueDateColumn;
    }

    private Column initProcessNameColumn() {
        Column<RequestSummary, String> col = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getProcessName();
            }
        };
        col.setSortable(true);
        col.setDataStoreName("processName");
        return col;
    }

    private Column initProcessInstanceIdColumn() {
        Column<RequestSummary, Number> col = new Column<RequestSummary, Number>((Cell)new NumberCell()){

            public Number getValue(RequestSummary object) {
                return object.getProcessInstanceId();
            }
        };
        col.setSortable(true);
        col.setDataStoreName("processInstanceId");
        return col;
    }

    private Column initProcessInstanceDescription() {
        Column<RequestSummary, String> col = new Column<RequestSummary, String>((Cell)new TextCell()){

            public String getValue(RequestSummary object) {
                return object.getProcessInstanceDescription();
            }
        };
        col.setSortable(true);
        col.setDataStoreName("processInstanceDescription");
        return col;
    }

    private Column<RequestSummary, RequestSummary> initActionsColumn() {
        LinkedList<ActionHasCell> cells = new LinkedList<ActionHasCell>();
        ArrayList<String> allStatuses = new ArrayList<String>();
        allStatuses.add("QUEUED");
        allStatuses.add("DONE");
        allStatuses.add("CANCELLED");
        allStatuses.add("ERROR");
        allStatuses.add("RETRYING");
        allStatuses.add("RUNNING");
        cells.add(new ActionHasCell(this.constants.Details(), allStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                ((RequestListPresenter)RequestListViewImpl.this.presenter).showJobDetails(job);
            }
        }));
        ArrayList<String> activeStatuses = new ArrayList<String>();
        activeStatuses.add("QUEUED");
        activeStatuses.add("RETRYING");
        activeStatuses.add("RUNNING");
        cells.add(new ActionHasCell(this.constants.Cancel(), activeStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)RequestListViewImpl.this.constants.CancelJob())) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).cancelRequest(job.getJobId());
                }
            }
        }));
        ArrayList<String> requeueStatuses = new ArrayList<String>();
        requeueStatuses.add("ERROR");
        requeueStatuses.add("RUNNING");
        cells.add(new ActionHasCell(this.constants.Requeue(), requeueStatuses, new ActionCell.Delegate<RequestSummary>(){

            public void execute(RequestSummary job) {
                if (Window.confirm((String)RequestListViewImpl.this.constants.RequeueJob())) {
                    ((RequestListPresenter)RequestListViewImpl.this.presenter).requeueRequest(job.getJobId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestSummary, RequestSummary> actionsColumn = new Column<RequestSummary, RequestSummary>((Cell)cell){

            public RequestSummary getValue(RequestSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((RequestListPresenter)this.presenter).setAddingDefaultFilters(true);
        ArrayList<String> statuses = new ArrayList<String>();
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_0", this.constants.All(), this.constants.FilterAll(), statuses);
        statuses = new ArrayList();
        statuses.add("QUEUED");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_1", this.constants.Queued(), this.constants.FilterQueued(), statuses);
        statuses = new ArrayList();
        statuses.add("RUNNING");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_2", this.constants.Running(), this.constants.FilterRunning(), statuses);
        statuses = new ArrayList();
        statuses.add("RETRYING");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_3", this.constants.Retrying(), this.constants.FilterRetrying(), statuses);
        statuses = new ArrayList();
        statuses.add("ERROR");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_4", this.constants.Error(), this.constants.FilterError(), statuses);
        statuses = new ArrayList();
        statuses.add("DONE");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_5", this.constants.Completed(), this.constants.FilterCompleted(), statuses);
        statuses = new ArrayList();
        statuses.add("CANCELLED");
        this.initTabFilter(preferences, REQUEST_LIST_PREFIX + "_6", this.constants.Cancelled(), this.constants.FilterCancelled(), statuses);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries(REQUEST_LIST_PREFIX + "_0");
    }

    private void initTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, List<String> statuses) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        if (statuses != null && statuses.size() > 0) {
            builder.dataset("jbpmRequestList");
            ArrayList<String> names = new ArrayList<String>();
            for (String s : statuses) {
                names.add(s);
            }
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        }
        builder.dataset("jbpmRequestList");
        builder.setColumn("id", this.constants.Id());
        builder.setColumn("timestamp", this.constants.Time(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("commandName", this.constants.CommandName());
        builder.setColumn("message", this.constants.Message());
        builder.setColumn("businessKey", this.constants.Key());
        builder.setColumn("retries", this.constants.Retries());
        builder.setColumn("executions", this.constants.Executions());
        builder.setColumn("processName", this.constants.Process_Name());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processInstanceDescription", this.constants.Process_Description());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("timestamp", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setUUID("jbpmRequestList");
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider(((RequestListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                RequestListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((RequestListPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmRequestList");
        builder.setColumn("id", this.constants.Id());
        builder.setColumn("timestamp", this.constants.Time(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("commandName", this.constants.CommandName(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("message", this.constants.Message());
        builder.setColumn("businessKey", this.constants.Key());
        builder.setColumn("retries", this.constants.Retries());
        builder.setColumn("executions", this.constants.Executions());
        builder.setColumn("processName", this.constants.Process_Name());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processInstanceDescription", this.constants.Process_Description());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("timestamp", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    public void resetDefaultFilterTitleAndDescription() {
        HashMap tabSettingsValues = null;
        tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_0");
        if (tabSettingsValues != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.All());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterAll());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_0", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_1")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Queued());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterQueued());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_1", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_2")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Running());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterRunning());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_2", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_3")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Retrying());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterRetrying());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_3", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_4")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Error());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterError());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_4", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_5")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Completed());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterCompleted());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_5", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(REQUEST_LIST_PREFIX + "_6")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, this.constants.Cancelled());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, this.constants.FilterCancelled());
            this.filterPagedTable.saveTabSettings(REQUEST_LIST_PREFIX + "_6", tabSettingsValues);
        }
    }

    private class ActionHasCell
    extends ButtonActionCell<RequestSummary> {
        private final List<String> availableStatuses;

        public ActionHasCell(String text, List<String> availableStatusesList, ActionCell.Delegate<RequestSummary> delegate) {
            super(text, delegate);
            this.availableStatuses = availableStatusesList;
        }

        public void render(Cell.Context context, RequestSummary value, SafeHtmlBuilder sb) {
            if (this.availableStatuses.contains(value.getStatus())) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

