/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListViewImplTest {
    @Mock
    protected ExtendedPagedTable<RequestSummary> currentListGrid;
    @Mock
    FilterPagedTable filterPagedTableMock;
    @Mock
    MultiGridPreferencesStore multiGridPreferencesStoreMock;
    @Mock
    protected GridPreferencesStore gridPreferencesStoreMock;
    @Mock
    protected Button mockButton;
    @Mock
    protected RequestListPresenter presenter;
    @Mock
    private DataSetEditorManager dataSetEditorManager;
    @Mock
    private AsyncDataProvider dataProvider;
    @Mock
    protected UserPreferencesService userPreferencesService;
    @Spy
    private FilterSettings filterSettings;
    @InjectMocks
    private RequestListViewImpl view;
    @Mock
    protected Cell.Context cellContext;
    @Mock
    protected ActionCell.Delegate<RequestSummary> cellDelegate;

    @Before
    public void setup() {
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn(Mockito.mock(AsyncDataProvider.class));
        Mockito.when((Object)this.presenter.createTableSettingsPrototype()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createAllTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createCancelledTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createCompletedTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createErrorTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createQueuedTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createRetryingTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createRunningTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createSearchTabSettings()).thenReturn((Object)this.filterSettings);
        CallerMock caller = new CallerMock((Object)this.userPreferencesService);
        this.view.setPreferencesService((Caller)caller);
    }

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        Mockito.when((Object)this.filterPagedTableMock.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStoreMock);
        this.view.resetDefaultFilterTitleAndDescription();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)8))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)8))).saveTabSettings(Mockito.anyString(), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)"base"), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_0")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_1")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_2")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_3")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_4")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_5")), (HashMap)Matchers.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).saveTabSettings((String)Matchers.eq((Object)(RequestListViewImpl.REQUEST_LIST_PREFIX + "_6")), (HashMap)Matchers.any(HashMap.class));
    }

    @Test
    public void initColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 9 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initialColumnsTest() {
        this.view.init(this.presenter);
        List columnPreferences = this.view.getListGrid().getGridPreferencesStore().getColumnPreferences();
        Assert.assertEquals((Object)"id", (Object)((GridColumnPreference)columnPreferences.get(0)).getName());
        Assert.assertEquals((Object)"businessKey", (Object)((GridColumnPreference)columnPreferences.get(1)).getName());
        Assert.assertEquals((Object)"commandName", (Object)((GridColumnPreference)columnPreferences.get(2)).getName());
        Assert.assertEquals((Object)"Actions", (Object)((GridColumnPreference)columnPreferences.get(3)).getName());
    }

    @Test
    public void initDefaultFiltersOwnTaskFilter() {
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn((Object)this.dataProvider);
        this.view.initDefaultFilters(new GridGlobalPreferences(), this.mockButton);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)8))).addTab((PagedTable)Matchers.any(ExtendedPagedTable.class), Mockito.anyString(), (Command)Matchers.any(Command.class), Matchers.eq((boolean)false));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).addAddTableButton(this.mockButton);
        ((RequestListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
    }

    @Test
    public void multiStateActionHasCellTest() {
        RequestListViewImpl.ActionHasCell multiStateCell = new RequestListViewImpl.ActionHasCell("", this.cellDelegate, new RequestStatus[]{RequestStatus.QUEUED, RequestStatus.DONE, RequestStatus.CANCELLED});
        for (RequestStatus rs : RequestStatus.values()) {
            RequestSummary testRequest = new RequestSummary(Long.valueOf(1L), new Date(), rs.toString(), null, "Test message", "Test key", Integer.valueOf(1), Integer.valueOf(1), "procName", Long.valueOf(55L), "procInstDesc");
            boolean shouldRender = false;
            switch (rs) {
                case QUEUED: 
                case DONE: 
                case CANCELLED: {
                    shouldRender = true;
                }
            }
            this.runActionHasCellTest(multiStateCell, testRequest, shouldRender);
        }
    }

    @Test
    public void singleStateActionHasCellTest() {
        for (RequestStatus cellRs : RequestStatus.values()) {
            RequestListViewImpl.ActionHasCell multiStateCell = new RequestListViewImpl.ActionHasCell("", this.cellDelegate, new RequestStatus[]{cellRs});
            for (RequestStatus valueRs : RequestStatus.values()) {
                RequestSummary testRequest = new RequestSummary(Long.valueOf(1L), new Date(), valueRs.toString(), null, "Test message", "Test key", Integer.valueOf(1), Integer.valueOf(1), "procName", Long.valueOf(55L), "procInstDesc");
                boolean shouldRender = valueRs == cellRs;
                this.runActionHasCellTest(multiStateCell, testRequest, shouldRender);
            }
        }
    }

    @Test
    public void predicateActionHasCellTest() {
        RequestSummary testRequest = new RequestSummary(Long.valueOf(1L), new Date(), "DONE", null, "Test message", "Test key", Integer.valueOf(1), Integer.valueOf(1), "procName", Long.valueOf(55L), "procInstDesc");
        RequestListViewImpl.ActionHasCell alwaysDisplayedActionCell = new RequestListViewImpl.ActionHasCell("", val -> true, this.cellDelegate);
        this.runActionHasCellTest(alwaysDisplayedActionCell, testRequest, true);
        RequestListViewImpl.ActionHasCell neverDisplayedActionCell = new RequestListViewImpl.ActionHasCell("", val -> false, this.cellDelegate);
        this.runActionHasCellTest(neverDisplayedActionCell, testRequest, false);
    }

    private void runActionHasCellTest(RequestListViewImpl.ActionHasCell cell, RequestSummary val, boolean shouldRender) {
        RequestListViewImpl.ActionHasCell cellMock = (RequestListViewImpl.ActionHasCell)Mockito.spy((Object)cell);
        SafeHtmlBuilder cellHtmlBuilder = (SafeHtmlBuilder)Mockito.mock(SafeHtmlBuilder.class);
        ((RequestListViewImpl.ActionHasCell)Mockito.doAnswer(invocationOnMock -> {
            invocationOnMock.callRealMethod();
            ((SafeHtmlBuilder)Mockito.verify((Object)cellHtmlBuilder, (VerificationMode)Mockito.times((int)(shouldRender ? 1 : 0)))).append((SafeHtml)Matchers.any());
            return null;
        }).when((Object)cellMock)).render((Cell.Context)Matchers.any(), (RequestSummary)Matchers.any(), (SafeHtmlBuilder)Matchers.eq((Object)cellHtmlBuilder));
        cellMock.render(this.cellContext, val, cellHtmlBuilder);
        ((RequestListViewImpl.ActionHasCell)Mockito.verify((Object)cellMock)).render(this.cellContext, val, cellHtmlBuilder);
    }
}

