/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errordetails;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.events.ExecErrorSelectionEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="Execution Error Details", preferredWidth=655)
public class ExecutionErrorDetailsPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    public static final String SCREEN_ID = "Execution Error Details";
    @Inject
    public ExecErrorDetailsView view;
    @Inject
    PlaceManager placeManager;
    @Inject
    private Event<ExecErrorSelectionEvent> execErrorSelected;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    private PlaceRequest place;
    private String serverTemplateId;
    private String deploymentId;
    private String errorId;
    @Inject
    private Caller<ExecutorService> executorServices;

    @WorkbenchPartView
    public UberElement<ExecutionErrorDetailsPresenter> getView() {
        return this.view;
    }

    @DefaultPosition
    public Position getPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    public void onExecErrorSelectionEvent(@Observes ExecErrorSelectionEvent event) {
        this.serverTemplateId = event.getServerTemplateId();
        this.deploymentId = event.getDeploymentId();
        this.errorId = event.getErrorId();
        this.refreshExecutionErrorDataRemote(this.serverTemplateId, this.deploymentId, this.errorId);
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(event.getErrorId() + " - " + event.getDeploymentId())));
    }

    public void refreshExecutionErrorDataRemote(String serverTemplateId, String deploymentId, String errorId) {
        ((ExecutorService)this.executorServices.call(executionErrorSummary -> this.view.setValue((ExecutionErrorSummary)executionErrorSummary))).getError(serverTemplateId, deploymentId, errorId);
    }

    public void onRefresh() {
        this.execErrorSelected.fire((Object)new ExecErrorSelectionEvent(this.serverTemplateId, this.deploymentId, this.errorId));
    }

    @Inject
    public void setExecutorService(Caller<ExecutorService> executorServices) {
        this.executorServices = executorServices;
    }

    @Inject
    public void setChangeTitleWidgetEvent(Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent) {
        this.changeTitleWidgetEvent = changeTitleWidgetEvent;
    }

    public static interface ExecErrorDetailsView
    extends UberElement<ExecutionErrorDetailsPresenter> {
        public void setValue(ExecutionErrorSummary var1);
    }
}

