/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.events.ExecErrorChangedEvent;
import org.jbpm.workbench.es.model.events.ExecErrorSelectionEvent;
import org.jbpm.workbench.es.model.events.ExecErrorWithDetailsRequestEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.ExecutionErrorType;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Execution Error List")
public class ExecutionErrorListPresenter
extends AbstractMultiGridPresenter<ExecutionErrorSummary, ExecutionErrorListView> {
    private final Constants constants = Constants.INSTANCE;
    public static final String SCREEN_ID = "Execution Error List";
    private List<ExecutionErrorSummary> visibleExecutionErrors = new ArrayList<ExecutionErrorSummary>();
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Caller<ExecutorService> executorService;
    @Inject
    private Event<ExecErrorSelectionEvent> execErrorSelectionEvent;
    @Inject
    private Event<ExecErrorChangedEvent> execErrorChangedEvent;

    public void getData(final Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                final FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
                currentTableSettings.setTablePageSize(((ExecutionErrorListView)this.view).getListGrid().getPageSize());
                ColumnSortList columnSortList = ((ExecutionErrorListView)this.view).getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("ERROR_DATE");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), (DataSetReadyCallback)new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, currentTableSettings.getUUID()){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null && ExecutionErrorListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                            ExecutionErrorListPresenter.this.visibleExecutionErrors.clear();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                ExecutionErrorListPresenter.this.visibleExecutionErrors.add(ExecutionErrorListPresenter.this.createExecutionErrorSummaryFromDataSet(dataSet, i));
                            }
                            boolean lastPageExactCount = false;
                            if (dataSet.getRowCount() < ((ExecutionErrorListView)ExecutionErrorListPresenter.this.view).getListGrid().getPageSize()) {
                                lastPageExactCount = true;
                            }
                            ExecutionErrorListPresenter.this.updateDataOnCallback(ExecutionErrorListPresenter.this.visibleExecutionErrors, visibleRange.getStart(), visibleRange.getStart() + ExecutionErrorListPresenter.this.visibleExecutionErrors.size(), lastPageExactCount);
                        }
                    }
                });
                ((ExecutionErrorListView)this.view).hideBusyIndicator();
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.Error() + " " + e.getMessage());
            ((ExecutionErrorListView)this.view).hideBusyIndicator();
        }
    }

    protected ExecutionErrorSummary createExecutionErrorSummaryFromDataSet(DataSet dataSet, Integer index) {
        return new ExecutionErrorSummary(DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_TYPE", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"DEPLOYMENT_ID", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"PROCESS_INST_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"PROCESS_ID", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"ACTIVITY_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ACTIVITY_NAME", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"JOB_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_MSG", (int)index), DataSetUtils.getColumnBooleanValue((DataSet)dataSet, (String)"ERROR_ACK", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_ACK_BY", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"ERROR_ACK_AT", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"ERROR_DATE", (int)index));
    }

    public void onExecErrorChanged(@Observes ExecErrorChangedEvent errorChangedEvent) {
        this.refreshGrid();
    }

    public void acknowledgeExecutionError(String executionErrorId, String deploymentId) {
        ((ExecutorService)this.executorService.call(nothing -> {
            ((ExecutionErrorListView)this.view).displayNotification(Constants.INSTANCE.ExecutionErrorAcknowledged(executionErrorId));
            this.execErrorChangedEvent.fire((Object)new ExecErrorChangedEvent(this.getSelectedServerTemplate(), deploymentId, executionErrorId));
            this.refreshGrid();
        })).acknowledgeError(this.getSelectedServerTemplate(), deploymentId, new String[]{executionErrorId});
    }

    public void goToJob(ExecutionErrorSummary errorSummary) {
        this.navigateToPerspective("Requests", "jobId", errorSummary.getJobId().toString());
    }

    public Predicate<ExecutionErrorSummary> getAcknowledgeActionCondition() {
        return pis -> !pis.isAcknowledged();
    }

    public Predicate<ExecutionErrorSummary> getViewJobActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("Requests") && pis.getJobId() != null;
    }

    public Predicate<ExecutionErrorSummary> getViewProcessInstanceActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ProcessInstances") && pis.getProcessInstanceId() != null;
    }

    public void goToProcessInstance(ExecutionErrorSummary errorSummary) {
        this.navigateToPerspective("ProcessInstances", "processInstanceId", errorSummary.getProcessInstanceId().toString());
    }

    public void bulkAcknowledge(List<ExecutionErrorSummary> execErrorsSelected) {
        if (execErrorsSelected == null || execErrorsSelected.isEmpty()) {
            return;
        }
        for (ExecutionErrorSummary selected : execErrorsSelected) {
            if (selected.isAcknowledged()) {
                ((ExecutionErrorListView)this.view).displayNotification("Error " + selected.getErrorId() + "is already acknowledge");
                continue;
            }
            this.acknowledgeExecutionError(selected.getErrorId(), selected.getDeploymentId());
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.ExecutionErrors();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    protected List<ExecutionErrorSummary> getDisplayedExecutionErrors() {
        return this.visibleExecutionErrors;
    }

    public void selectExecutionError(ExecutionErrorSummary summary, Boolean close) {
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Execution Error Details"));
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo("Execution Error Details");
            this.execErrorSelectionEvent.fire((Object)new ExecErrorSelectionEvent(this.getSelectedServerTemplate(), summary.getDeploymentId(), summary.getErrorId()));
        } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
            this.execErrorSelectionEvent.fire((Object)new ExecErrorSelectionEvent(this.getSelectedServerTemplate(), summary.getDeploymentId(), summary.getErrorId()));
        } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
            this.placeManager.closePlace("Execution Error Details");
        }
    }

    public void onExecutionErrorSelectionEvent(@Observes ExecErrorWithDetailsRequestEvent event) {
        this.placeManager.goTo("Execution Error Details");
        this.execErrorSelectionEvent.fire((Object)new ExecErrorSelectionEvent(event.getServerTemplateId(), event.getDeploymentId(), event.getErrorId()));
    }

    @Inject
    public void setExecutorService(Caller<ExecutorService> executorService) {
        this.executorService = executorService;
    }

    public void setupAdvancedSearchView() {
        ((ExecutionErrorListView)this.view).addNumericFilter(this.constants.Id(), this.constants.FilterByErrorId(), v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ID", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ID", (Comparable)((Object)v))));
        ((ExecutionErrorListView)this.view).addNumericFilter(this.constants.Process_Instance_Id(), this.constants.FilterByProcessInstanceId(), v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)((Object)v))));
        ((ExecutionErrorListView)this.view).addNumericFilter(this.constants.JobId(), this.constants.FilterByJobId(), v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"JOB_ID", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"JOB_ID", (Comparable)((Object)v))));
        HashMap<String, String> states = new HashMap<String, String>();
        states.put(String.valueOf(ExecutionErrorType.DB), this.constants.DB());
        states.put(String.valueOf(ExecutionErrorType.TASK), this.constants.Task());
        states.put(String.valueOf(ExecutionErrorType.PROCESS), this.constants.Process());
        ((ExecutionErrorListView)this.view).addSelectFilter(this.constants.Type(), states, false, v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_TYPE", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_TYPE", (Comparable)((Object)v))));
        HashMap<String, String> acks = new HashMap<String, String>();
        org.jbpm.workbench.common.client.resources.i18n.Constants constants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
        acks.put(String.valueOf(Boolean.TRUE), constants.Yes());
        acks.put(String.valueOf(Boolean.FALSE), constants.No());
        ((ExecutionErrorListView)this.view).addSelectFilter(this.constants.Acknowledged(), acks, false, v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)((Object)v))));
        ((ExecutionErrorListView)this.view).addDateRangeFilter(this.constants.ErrorDate(), v -> this.addAdvancedSearchFilter(FilterFactory.between((String)"ERROR_DATE", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())), v -> this.removeAdvancedSearchFilter(FilterFactory.between((String)"ERROR_DATE", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())));
    }

    public void setupActiveSearchFilters() {
        Optional processInstanceSearch = this.getSearchParameter("processInstanceId");
        if (processInstanceSearch.isPresent()) {
            String processInstanceId = (String)processInstanceSearch.get();
            ((ExecutionErrorListView)this.view).addActiveFilter(this.constants.Process_Instance_Id(), processInstanceId, processInstanceId, v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)((Object)v))));
            this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)((Object)processInstanceId)));
        } else {
            this.setupDefaultActiveSearchFilters();
        }
    }

    public void setupDefaultActiveSearchFilters() {
        ((ExecutionErrorListView)this.view).addActiveFilter(this.constants.Acknowledged(), org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.No(), String.valueOf(Boolean.FALSE), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)((Object)v))));
        this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)((Object)String.valueOf(Boolean.FALSE))));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmExecutionErrorList");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("ERROR_DATE", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        return builder.buildSettings();
    }

    private FilterSettings createFilterTabSettings(Boolean acknowledged) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmExecutionErrorList");
        if (acknowledged != null) {
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)acknowledged)});
        }
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("ERROR_DATE", SortOrder.DESCENDING);
        this.addCommonColumnSettings(builder);
        return builder.buildSettings();
    }

    public FilterSettings createAllTabSettings() {
        return this.createFilterTabSettings(null);
    }

    public FilterSettings createAcknowledgedTabSettings() {
        return this.createFilterTabSettings(Boolean.TRUE);
    }

    public FilterSettings createNewTabSettings() {
        return this.createFilterTabSettings(Boolean.FALSE);
    }

    public FilterSettings createSearchTabSettings() {
        return this.createTableSettingsPrototype();
    }

    protected void addCommonColumnSettings(FilterSettingsBuilderHelper builder) {
        builder.setColumn("ERROR_ACK", this.constants.Ack());
        builder.setColumn("ERROR_ACK_AT", this.constants.AckAt());
        builder.setColumn("ERROR_ACK_BY", this.constants.AckBy());
        builder.setColumn("ACTIVITY_ID", this.constants.ActivityId());
        builder.setColumn("ACTIVITY_NAME", this.constants.ActivityName());
        builder.setColumn("DEPLOYMENT_ID", this.constants.DeploymentId());
        builder.setColumn("ERROR_DATE", this.constants.Date());
        builder.setColumn("ERROR_ID", this.constants.Id());
        builder.setColumn("ERROR_MSG", this.constants.Message());
        builder.setColumn("JOB_ID", this.constants.JobId());
        builder.setColumn("PROCESS_ID", this.constants.ProcessId());
        builder.setColumn("PROCESS_INST_ID", this.constants.Process_Instance_Id());
        builder.setColumn("ERROR_TYPE", this.constants.Type());
    }

    public static interface ExecutionErrorListView
    extends MultiGridView<ExecutionErrorSummary, ExecutionErrorListPresenter> {
    }
}

