/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.BooleanConverter;
import org.jbpm.workbench.common.client.util.ConditionalButtonActionCell;
import org.jbpm.workbench.common.client.util.DateConverter;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.client.util.ExecutionErrorTypeConverter;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class ExecutionErrorListViewImpl
extends AbstractMultiGridView<ExecutionErrorSummary, ExecutionErrorListPresenter>
implements ExecutionErrorListPresenter.ExecutionErrorListView {
    private static final String TAB_ALL = "DS_ExecutionErrorListGrid_0";
    private static final String TAB_ACK = "DS_ExecutionErrorListGrid_1";
    private static final String TAB_NEW = "DS_ExecutionErrorListGrid_2";
    private final Constants constants = Constants.INSTANCE;
    @Inject
    ConfirmPopup confirmPopup;
    @Inject
    ExecutionErrorTypeConverter executionErrorTypeConverter;
    @Inject
    DateConverter dateConverter;
    @Inject
    BooleanConverter booleanConverter;

    public void init(ExecutionErrorListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("Select");
        bannedColumns.add("ERROR_ID");
        bannedColumns.add("ERROR_TYPE");
        bannedColumns.add("PROCESS_INST_ID");
        bannedColumns.add("ERROR_DATE");
        bannedColumns.add("Actions");
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("Select");
        initColumns.add("ERROR_ID");
        initColumns.add("ERROR_TYPE");
        initColumns.add("PROCESS_INST_ID");
        initColumns.add("ERROR_DATE");
        initColumns.add("DEPLOYMENT_ID");
        initColumns.add("Actions");
        this.createTabButton.addClickHandler(event -> {
            String key = this.getValidKeyForAdditionalListGrid("DS_ExecutionErrorListGrid_");
            Command addNewGrid = () -> {
                ExtendedPagedTable extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, this.createTabButton, () -> {
                    this.currentListGrid = extendedPagedTable;
                    this.applyFilterOnPresenter(key);
                });
                this.applyFilterOnPresenter(key);
            };
            FilterSettings tableSettings = presenter.createTableSettingsPrototype();
            tableSettings.setKey(key);
            this.dataSetEditorManager.showTableSettingsEditor(this.filterPagedTable, this.constants.New_ErrorList(), tableSettings, addNewGrid);
        });
        super.init((AbstractMultiGridPresenter)presenter, new GridGlobalPreferences("DS_ExecutionErrorListGrid", initColumns, bannedColumns));
    }

    public void initSelectionModel(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Execution_Errors_Found());
        extendedPagedTable.setSelectionCallback((error, close) -> ((ExecutionErrorListPresenter)this.presenter).selectExecutionError((ExecutionErrorSummary)error, (Boolean)close));
        this.initBulkActions(extendedPagedTable);
    }

    private void initBulkActions(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        extendedPagedTable.getRightActionsToolbar().clear();
        AnchorListItem bulkAckNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAckNavLink.setText(this.constants.Bulk_Ack());
        ButtonGroup bulkActions = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button bulkButton = (Button)GWT.create(Button.class);
        bulkButton.setText(this.constants.Bulk_Actions());
        bulkButton.setDataToggle(Toggle.DROPDOWN);
        bulkButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkActions.add((Widget)bulkButton);
        DropDownMenu bulkDropDown = (DropDownMenu)GWT.create(DropDownMenu.class);
        bulkDropDown.addStyleName("dropdown-menu-right");
        bulkDropDown.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkDropDown.add((Widget)bulkAckNavLink);
        bulkActions.add((Widget)bulkDropDown);
        bulkAckNavLink.setIcon(IconType.BAN);
        bulkAckNavLink.setIconFixedWidth(true);
        bulkAckNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Bulk_Ack(), this.constants.Acknowledge(), this.constants.Bulk_Ack_confirm(), () -> {
            ((ExecutionErrorListPresenter)this.presenter).bulkAcknowledge(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
            extendedPagedTable.redraw();
        }));
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
    }

    public void initColumns(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ID", errorSummary -> errorSummary.getErrorId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_TYPE", errorSummary -> this.executionErrorTypeConverter.toWidgetValue(errorSummary.getType())), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK", errorSummary -> this.booleanConverter.toWidgetValue(Boolean.valueOf(errorSummary.isAcknowledged()))), this.constants.Ack()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_AT", errorSummary -> this.dateConverter.toWidgetValue(errorSummary.getAcknowledgedAt())), this.constants.AckAt()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_BY", errorSummary -> errorSummary.getAcknowledgedBy()), this.constants.AckBy()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("JOB_ID", errorSummary -> errorSummary.getJobId()), this.constants.JobId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("PROCESS_ID", errorSummary -> errorSummary.getProcessId()), this.constants.ProcessId()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("PROCESS_INST_ID", errorSummary -> errorSummary.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("ACTIVITY_ID", errorSummary -> errorSummary.getActivityId()), this.constants.ActivityId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ACTIVITY_NAME", errorSummary -> errorSummary.getActivityName()), this.constants.ActivityName()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("DEPLOYMENT_ID", errorSummary -> errorSummary.getDeploymentId()), this.constants.DeploymentId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_DATE", errorSummary -> this.dateConverter.toWidgetValue(errorSummary.getErrorDate())), this.constants.ErrorDate()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_MSG", errorSummary -> errorSummary.getErrorMessage()), this.constants.Message()));
        Column<ExecutionErrorSummary, ExecutionErrorSummary> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ColumnMeta actionsColumnMeta = new ColumnMeta(actionsColumn, this.constants.Actions());
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 260.0, Style.Unit.PX);
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column<ExecutionErrorSummary, ExecutionErrorSummary> initActionsColumn() {
        LinkedList<ConditionalButtonActionCell> cells = new LinkedList<ConditionalButtonActionCell>();
        cells.add(new ConditionalButtonActionCell(this.constants.Acknowledge(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).acknowledgeExecutionError(errorSummary.getErrorId(), errorSummary.getDeploymentId()), ((ExecutionErrorListPresenter)this.presenter).getAcknowledgeActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewJob(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToJob((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewJobActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewProcessInstance(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToProcessInstance((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewProcessInstanceActionCondition()));
        CompositeCell cell = new CompositeCell(cells);
        Column<ExecutionErrorSummary, ExecutionErrorSummary> actionsColumn = new Column<ExecutionErrorSummary, ExecutionErrorSummary>((Cell)cell){

            public ExecutionErrorSummary getValue(ExecutionErrorSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        super.initDefaultFilters(preferences, createTabButton);
        this.initGenericTabFilter(((ExecutionErrorListPresenter)this.presenter).createAllTabSettings(), TAB_ALL, this.constants.All(), this.constants.FilterAll(), preferences);
        this.initGenericTabFilter(((ExecutionErrorListPresenter)this.presenter).createNewTabSettings(), TAB_NEW, this.constants.New(), this.constants.UnacknowledgedErrors(), preferences);
        this.initGenericTabFilter(((ExecutionErrorListPresenter)this.presenter).createAcknowledgedTabSettings(), TAB_ACK, this.constants.Acknowledged(), this.constants.AcknowledgedErrors(), preferences);
        this.filterPagedTable.addAddTableButton(createTabButton);
    }

    private void initGenericTabFilter(FilterSettings tableSettings, String key, String tabName, String tabDesc, GridGlobalPreferences preferences) {
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        tableSettings.setUUID("jbpmExecutionErrorList");
        this.addNewTab(preferences, tableSettings);
    }

    public void resetDefaultFilterTitleAndDescription() {
        super.resetDefaultFilterTitleAndDescription();
        this.saveTabSettings(TAB_NEW, this.constants.New(), this.constants.UnacknowledgedErrors());
        this.saveTabSettings(TAB_ACK, this.constants.Acknowledge(), this.constants.AcknowledgedErrors());
        this.saveTabSettings(TAB_ALL, this.constants.All(), this.constants.FilterAll());
    }
}

