/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.view.client.AbstractDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.ui.Button;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.ButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.util.RequestStatus;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private final Constants constants = Constants.INSTANCE;
    public static String REQUEST_LIST_PREFIX = "DS_RequestListGrid";
    public static final String COL_ID_ACTIONS = "Actions";
    private static final String TAB_CANCELLED = REQUEST_LIST_PREFIX + "_6";
    private static final String TAB_COMPLETED = REQUEST_LIST_PREFIX + "_5";
    private static final String TAB_ERROR = REQUEST_LIST_PREFIX + "_4";
    private static final String TAB_RETRYING = REQUEST_LIST_PREFIX + "_3";
    private static final String TAB_RUNNING = REQUEST_LIST_PREFIX + "_2";
    private static final String TAB_QUEUED = REQUEST_LIST_PREFIX + "_1";
    private static final String TAB_ALL = REQUEST_LIST_PREFIX + "_0";

    public void init(final RequestListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("id");
        bannedColumns.add("commandName");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("id");
        initColumns.add("businessKey");
        initColumns.add("commandName");
        initColumns.add(COL_ID_ACTIONS);
        this.createTabButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = RequestListViewImpl.this.getValidKeyForAdditionalListGrid(REQUEST_LIST_PREFIX + "_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = RequestListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        RequestListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, RequestListViewImpl.this.createTabButton, new Command(){

                            public void execute() {
                                RequestListViewImpl.this.currentListGrid = extendedPagedTable;
                                RequestListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        RequestListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = presenter.createTableSettingsPrototype();
                tableSettings.setKey(key);
                RequestListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(RequestListViewImpl.this.filterPagedTable, RequestListViewImpl.this.constants.New_JobList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractMultiGridPresenter)presenter, new GridGlobalPreferences(REQUEST_LIST_PREFIX, initColumns, bannedColumns));
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column<RequestSummary, RequestSummary> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("id", req -> req.getJobId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("businessKey", req -> req.getKey()), this.constants.BusinessKey()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("commandName", req -> req.getCommandName()), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", req -> req.getStatus()), this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("timestamp", req -> DateUtils.getDateTimeStr((Date)req.getTime())), this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", req -> req.getProcessName()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", req -> req.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", req -> req.getProcessInstanceDescription()), this.constants.Process_Description()));
        columnMetas.add(new ColumnMeta(actionsColumn, this.constants.Actions()));
        extendedPagedTable.addColumns(columnMetas);
    }

    public void initSelectionModel(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
    }

    private Column<RequestSummary, RequestSummary> initActionsColumn() {
        LinkedList<ActionHasCell> cells = new LinkedList<ActionHasCell>();
        cells.add(new ActionHasCell(this.constants.Details(), (ActionCell.Delegate<RequestSummary>)((ActionCell.Delegate)job -> ((RequestListPresenter)this.presenter).showJobDetails((RequestSummary)job)), RequestStatus.QUEUED, RequestStatus.DONE, RequestStatus.CANCELLED, RequestStatus.ERROR, RequestStatus.RETRYING, RequestStatus.RUNNING));
        cells.add(new ActionHasCell(this.constants.Cancel(), (ActionCell.Delegate<RequestSummary>)((ActionCell.Delegate)job -> {
            if (Window.confirm((String)this.constants.CancelJob())) {
                ((RequestListPresenter)this.presenter).cancelRequest(job.getJobId());
            }
        }), RequestStatus.QUEUED, RequestStatus.RETRYING, RequestStatus.RUNNING));
        cells.add(new ActionHasCell(this.constants.Requeue(), (ActionCell.Delegate<RequestSummary>)((ActionCell.Delegate)job -> {
            if (Window.confirm((String)this.constants.RequeueJob())) {
                ((RequestListPresenter)this.presenter).requeueRequest(job.getJobId());
            }
        }), RequestStatus.ERROR, RequestStatus.RUNNING));
        cells.add(new ActionHasCell(this.constants.ViewProcessInstance(), job -> job.getProcessInstanceId() != null, (ActionCell.Delegate<RequestSummary>)((ActionCell.Delegate)job -> ((RequestListPresenter)this.presenter).openProcessInstanceView(Long.toString(job.getProcessInstanceId())))));
        CompositeCell cell = new CompositeCell(cells);
        Column<RequestSummary, RequestSummary> actionsColumn = new Column<RequestSummary, RequestSummary>((Cell)cell){

            public RequestSummary getValue(RequestSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        super.initDefaultFilters(preferences, createTabButton);
        this.initTabFilter(((RequestListPresenter)this.presenter).createAllTabSettings(), TAB_ALL, this.constants.All(), this.constants.FilterAll(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createQueuedTabSettings(), TAB_QUEUED, this.constants.Queued(), this.constants.FilterQueued(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createRunningTabSettings(), TAB_RUNNING, this.constants.Running(), this.constants.FilterRunning(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createRetryingTabSettings(), TAB_RETRYING, this.constants.Retrying(), this.constants.FilterRetrying(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createErrorTabSettings(), TAB_ERROR, this.constants.Error(), this.constants.FilterError(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createCompletedTabSettings(), TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted(), preferences);
        this.initTabFilter(((RequestListPresenter)this.presenter).createCancelledTabSettings(), TAB_CANCELLED, this.constants.Cancelled(), this.constants.FilterCancelled(), preferences);
        this.filterPagedTable.addAddTableButton(createTabButton);
    }

    private void initTabFilter(FilterSettings tableSettings, String key, String tabName, String tabDesc, GridGlobalPreferences preferences) {
        tableSettings.setUUID("jbpmRequestList");
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        this.addNewTab(preferences, tableSettings);
    }

    public void resetDefaultFilterTitleAndDescription() {
        super.resetDefaultFilterTitleAndDescription();
        this.saveTabSettings(TAB_ALL, this.constants.All(), this.constants.FilterAll());
        this.saveTabSettings(TAB_QUEUED, this.constants.Queued(), this.constants.FilterQueued());
        this.saveTabSettings(TAB_RUNNING, this.constants.Running(), this.constants.FilterRunning());
        this.saveTabSettings(TAB_RETRYING, this.constants.Retrying(), this.constants.FilterRetrying());
        this.saveTabSettings(TAB_ERROR, this.constants.Error(), this.constants.FilterError());
        this.saveTabSettings(TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted());
        this.saveTabSettings(TAB_CANCELLED, this.constants.Cancelled(), this.constants.FilterCancelled());
    }

    static class ActionHasCell
    extends ButtonActionCell<RequestSummary> {
        private final Predicate<RequestSummary> showCondition;
        private List<String> availableStatuses = null;

        public ActionHasCell(String text, ActionCell.Delegate<RequestSummary> delegate, RequestStatus ... status) {
            super(text, delegate);
            this.availableStatuses = Arrays.stream(status).map(s -> s.name()).collect(Collectors.toList());
            this.showCondition = value -> this.availableStatuses.contains(value.getStatus());
        }

        public ActionHasCell(String text, Predicate<RequestSummary> showCondition, ActionCell.Delegate<RequestSummary> delegate) {
            super(text, delegate);
            this.showCondition = showCondition;
        }

        public void render(Cell.Context context, RequestSummary value, SafeHtmlBuilder sb) {
            if (this.showCondition.test(value)) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

