/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.BooleanConverter;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.DateTimeConverter;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.client.util.ExecutionErrorTypeConverter;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractMultiGridView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class ExecutionErrorListViewImpl
extends AbstractMultiGridView<ExecutionErrorSummary, ExecutionErrorListPresenter>
implements ExecutionErrorListPresenter.ExecutionErrorListView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    ConfirmPopup confirmPopup;
    @Inject
    ExecutionErrorTypeConverter executionErrorTypeConverter;
    @Inject
    DateTimeConverter dateTimeConverter;
    @Inject
    BooleanConverter booleanConverter;

    public List<String> getInitColumns() {
        return Arrays.asList("Select", "ERROR_TYPE", "PROCESS_INST_ID", "ERROR_DATE", "DEPLOYMENT_ID", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("Select", "ERROR_TYPE", "PROCESS_INST_ID", "ERROR_DATE", "Actions");
    }

    public void initSelectionModel(ListTable<ExecutionErrorSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Execution_Errors_Found());
        extendedPagedTable.setSelectionCallback(error -> ((ExecutionErrorListPresenter)this.presenter).selectExecutionError((ExecutionErrorSummary)error));
        this.initBulkActions((ExtendedPagedTable)extendedPagedTable);
    }

    public List<AnchorListItem> getBulkActionsItems(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        ArrayList<AnchorListItem> bulkActionsItems = new ArrayList<AnchorListItem>();
        bulkActionsItems.add(this.getBulkAck(extendedPagedTable));
        return bulkActionsItems;
    }

    protected AnchorListItem getBulkAck(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        AnchorListItem bulkAckNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAckNavLink.setText(this.constants.Bulk_Ack());
        bulkAckNavLink.setIcon(IconType.BAN);
        bulkAckNavLink.setIconFixedWidth(true);
        bulkAckNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Bulk_Ack(), this.constants.Acknowledge(), this.constants.Bulk_Ack_confirm(), () -> {
            ((ExecutionErrorListPresenter)this.presenter).bulkAcknowledge(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
        }));
        return bulkAckNavLink;
    }

    public void initColumns(ListTable<ExecutionErrorSummary> extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        extendedPagedTable.addSelectionIgnoreColumn(checkColumnMeta.getColumn());
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ID", errorSummary -> errorSummary.getErrorId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_TYPE", errorSummary -> this.executionErrorTypeConverter.toWidgetValue(errorSummary.getType())), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK", errorSummary -> this.booleanConverter.toWidgetValue(Boolean.valueOf(errorSummary.isAcknowledged()))), this.constants.Ack()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_AT", errorSummary -> this.dateTimeConverter.toWidgetValue(errorSummary.getAcknowledgedAt())), this.constants.AckAt()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_BY", errorSummary -> errorSummary.getAcknowledgedBy()), this.constants.AckBy()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("JOB_ID", errorSummary -> errorSummary.getJobId()), this.constants.JobId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("PROCESS_ID", errorSummary -> errorSummary.getProcessId()), this.constants.ProcessId()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("PROCESS_INST_ID", errorSummary -> errorSummary.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("ACTIVITY_ID", errorSummary -> errorSummary.getActivityId()), this.constants.ActivityId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ACTIVITY_NAME", errorSummary -> errorSummary.getActivityName()), this.constants.ActivityName()));
        Column errorDateColumn = this.createTextColumn("ERROR_DATE", errorSummary -> this.dateTimeConverter.toWidgetValue(errorSummary.getErrorDate()));
        errorDateColumn.setDefaultSortAscending(false);
        columnMetas.add(new ColumnMeta(errorDateColumn, this.constants.ErrorDate()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("DEPLOYMENT_ID", errorSummary -> errorSummary.getDeploymentId()), this.constants.DeploymentId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_MSG", errorSummary -> errorSummary.getErrorMessage()), this.constants.Message()));
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 175.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(errorDateColumn);
    }

    protected List<ConditionalAction<ExecutionErrorSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Acknowledge(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).acknowledgeExecutionError(errorSummary.getErrorId(), errorSummary.getDeploymentId()), ((ExecutionErrorListPresenter)this.presenter).getAcknowledgeActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.ViewProcessInstance(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToProcessInstance((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewProcessInstanceActionCondition(), Boolean.valueOf(true)), new ConditionalAction(this.constants.ViewJob(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToJob((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewJobActionCondition(), Boolean.valueOf(true)), new ConditionalAction(this.constants.ViewTask(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToTask((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewTaskActionCondition(), Boolean.valueOf(true)));
    }
}

