/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.quicknewjob;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.NumberInput;
import org.jboss.errai.common.client.dom.RadioInput;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.es.client.editors.quicknewjob.NewJobPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.views.pfly.widgets.DateRangePicker;
import org.uberfire.client.views.pfly.widgets.DateRangePickerOptions;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.FormLabel;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.client.views.pfly.widgets.Moment;
import org.uberfire.client.views.pfly.widgets.ValidationState;
import org.uberfire.ext.widgets.common.client.tables.ResizableHeader;
import org.uberfire.ext.widgets.table.client.DataGrid;

@Dependent
@Templated
public class NewJobViewImpl
implements NewJobPresenter.NewJobView,
UberElement<NewJobPresenter> {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    @DataField(value="basic-tab")
    ListItem basicTab;
    @Inject
    @DataField(value="basic-pane")
    private Div basicPane;
    @Inject
    @DataField(value="advanced-tab")
    ListItem advancedTab;
    @Inject
    @DataField(value="advanced-pane")
    private Div advancedPane;
    @Inject
    @DataField(value="advanced-content")
    private FlowPanel advancedContent;
    @Inject
    @DataField(value="job-name-label")
    private FormLabel jobNameLabel;
    @Inject
    @DataField(value="job-name-input")
    private TextInput jobNameInput;
    @Inject
    @DataField(value="job-name-group")
    private FormGroup jobNameGroup;
    @Inject
    @DataField(value="job-name-help")
    private Span jobNameHelp;
    @Inject
    @DataField(value="date-filters-input")
    Div dateFiltersInput;
    @Inject
    @DataField(value="run-now")
    private RadioInput jobRunNowRadio;
    @Inject
    @DataField(value="job-type-label")
    private FormLabel jobTypeLabel;
    @Inject
    @DataField(value="job-type-input")
    private TextInput jobTypeInput;
    @Inject
    @DataField(value="job-type-group")
    private FormGroup jobTypeGroup;
    @Inject
    @DataField(value="job-type-help")
    private Span jobTypeHelp;
    @Inject
    @DataField(value="job-retries-label")
    private FormLabel jobRetriesLabel;
    @Inject
    @DataField(value="job-retries-input")
    private NumberInput jobRetriesInput;
    @Inject
    @DataField(value="job-retries-group")
    private FormGroup jobRetriesGroup;
    @Inject
    @DataField(value="job-retries-help")
    private Span jobRetriesHelp;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    @DataField(value="alert")
    private InlineNotification inlineNotification;
    @Inject
    private ManagedInstance<DateRangePicker> dateRangePickerProvider;
    private DateRangePicker dateRangePicker;
    private Date selectedDate;
    protected NewJobPresenter presenter;
    private ListDataProvider<RequestParameterSummary> dataProvider = new ListDataProvider();
    public DataGrid<RequestParameterSummary> myParametersGrid = new DataGrid();
    private boolean redrawParametersGrid;

    public void init(NewJobPresenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.jobNameLabel.addRequiredIndicator();
        this.jobTypeLabel.addRequiredIndicator();
        this.jobRetriesLabel.addRequiredIndicator();
        this.jobRetriesInput.setType("number");
        this.jobRetriesInput.setAttribute("min", "0");
        this.jobRetriesInput.setDefaultValue("0");
        this.jobRetriesInput.addEventListener("keypress", this.getNumericInputListener(), false);
        this.myParametersGrid.setHeight("200px");
        this.myParametersGrid.setEmptyTableWidget((Widget)new Label(this.constants.No_Parameters_added_yet()));
        this.initGridColumns();
        this.initDateTimePicker();
        Button button = (Button)GWT.create(Button.class);
        button.setText(Constants.INSTANCE.Add_Parameter());
        button.addClickHandler(e -> this.addNewParameter());
        this.advancedContent.add(this.myParametersGrid);
        this.advancedContent.add((Widget)button);
        this.inlineNotification.setType(InlineNotification.InlineNotificationType.DANGER);
    }

    protected EventListener<KeyboardEvent> getNumericInputListener() {
        return e -> {
            int keyCode = e.getKeyCode();
            if (keyCode <= 0) {
                keyCode = e.getWhich();
            }
            if (!(keyCode >= 96 && keyCode <= 105 || keyCode >= 48 && keyCode <= 57 || keyCode == 8 || keyCode == 37 || keyCode == 39)) {
                e.preventDefault();
            }
        };
    }

    @Override
    public void show() {
        this.cleanForm();
        this.modal.show();
        this.redrawParametersGrid = true;
    }

    protected void initDateTimePicker() {
        this.dateRangePicker = (DateRangePicker)this.dateRangePickerProvider.get();
        this.dateRangePicker.getElement().setReadOnly(true);
        this.dateRangePicker.getElement().setAttribute("placeholder", Constants.INSTANCE.Due_On());
        this.dateRangePicker.getElement().getClassList().add("form-control");
        Div div = (Div)Window.getDocument().createElement("div");
        div.setAttribute("data-filter", "Date");
        div.getClassList().add("input-group");
        div.getClassList().add("filter-control");
        div.appendChild((Node)this.dateRangePicker.getElement());
        this.dateFiltersInput.appendChild((Node)div);
        this.dateFiltersInput.setHidden(true);
    }

    protected void resetDateTimePicker() {
        DateRangePickerOptions options = this.getDateRangePickerOptions();
        this.dateRangePicker.setup(options, null);
        this.dateRangePicker.addApplyListener((e, p) -> {
            this.selectedDate = p.getStartDate().milliseconds(0).asDate();
            this.dateRangePicker.getElement().setAttribute("placeholder", DateUtils.getDateTimeStr((Date)this.selectedDate));
        });
    }

    protected DateRangePickerOptions getDateRangePickerOptions() {
        DateRangePickerOptions options = DateRangePickerOptions.create();
        options.setAutoUpdateInput(Boolean.valueOf(false));
        options.setAutoApply(Boolean.valueOf(true));
        options.setTimePicker(Boolean.valueOf(true));
        options.setTimePickerIncrement(1);
        options.setSingleDatePicker(Boolean.valueOf(true));
        options.setMinDate(Moment.Builder.moment());
        options.setParentEl("[data-field='modal']");
        return options;
    }

    public void cleanForm() {
        this.showBasicPane();
        this.selectedDate = new Date();
        this.jobRunNowRadio.setChecked(true);
        this.dateFiltersInput.setHidden(true);
        this.jobNameInput.setValue("");
        this.jobTypeInput.setValue("");
        this.jobRetriesInput.setValue("0");
        this.dataProvider.getList().clear();
        this.cleanErrorMessages();
    }

    @Override
    public void showBasicPane() {
        DOMUtil.addCSSClass((HTMLElement)this.basicTab, (String)"active");
        DOMUtil.addCSSClass((HTMLElement)this.basicPane, (String)"active");
        this.basicPane.setHidden(false);
        DOMUtil.removeCSSClass((HTMLElement)this.advancedTab, (String)"active");
        DOMUtil.removeCSSClass((HTMLElement)this.advancedPane, (String)"active");
        this.advancedPane.setHidden(true);
    }

    @Override
    public void cleanErrorMessages() {
        this.jobNameGroup.clearValidationState();
        this.jobNameHelp.setTextContent("");
        this.jobTypeGroup.clearValidationState();
        this.jobTypeHelp.setTextContent("");
        this.jobRetriesGroup.clearValidationState();
        this.jobRetriesHelp.setTextContent("");
        DOMUtil.addCSSClass((HTMLElement)this.inlineNotification.getElement(), (String)"hidden");
    }

    @Override
    public void showInlineNotification(String messages) {
        if (messages.isEmpty()) {
            return;
        }
        this.inlineNotification.setMessage(messages);
        DOMUtil.removeCSSClass((HTMLElement)this.inlineNotification.getElement(), (String)"hidden");
    }

    @Override
    public void showEmptyNameErrorMessage() {
        this.jobNameGroup.setValidationState(ValidationState.ERROR);
        this.jobNameHelp.setTextContent(Constants.INSTANCE.The_Job_Must_Have_A_BusinessKey());
    }

    @Override
    public void showInvalidTypeErrorMessage() {
        this.jobTypeGroup.setValidationState(ValidationState.ERROR);
        this.jobTypeHelp.setTextContent(Constants.INSTANCE.The_Job_Must_Have_A_Valid_Type());
    }

    @Override
    public void showEmptyTypeErrorMessage() {
        this.jobTypeGroup.setValidationState(ValidationState.ERROR);
        this.jobTypeHelp.setTextContent(Constants.INSTANCE.The_Job_Must_Have_A_Type());
    }

    @Override
    public void showEmptyRetriesErrorMessage() {
        this.jobRetriesGroup.setValidationState(ValidationState.ERROR);
        this.jobRetriesHelp.setTextContent(Constants.INSTANCE.The_Job_Must_Have_A_Positive_Number_Of_Reties());
    }

    public void removeRow(int index) {
        this.dataProvider.getList().remove(index);
    }

    public void addRow(RequestParameterSummary parameter) {
        this.dataProvider.getList().add(parameter);
    }

    private void initGridColumns() {
        Column<RequestParameterSummary, String> paramKeyColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getKey();
            }
        };
        paramKeyColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setKey(value);
                NewJobViewImpl.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramKeyColumn, (Header)new ResizableHeader(this.constants.Key(), this.myParametersGrid, (Column)paramKeyColumn));
        Column<RequestParameterSummary, String> paramValueColumn = new Column<RequestParameterSummary, String>((Cell)new EditTextCell()){

            public String getValue(RequestParameterSummary rowObject) {
                return rowObject.getValue();
            }
        };
        paramValueColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                object.setValue(value);
                NewJobViewImpl.this.dataProvider.getList().set(index, object);
            }
        });
        this.myParametersGrid.addColumn((Column)paramValueColumn, (Header)new ResizableHeader(this.constants.Value(), this.myParametersGrid, (Column)paramValueColumn));
        ButtonCell buttonCell = new ButtonCell(ButtonType.DANGER, IconType.TRASH);
        Column<RequestParameterSummary, String> actionsColumn = new Column<RequestParameterSummary, String>((Cell)buttonCell){

            public String getValue(RequestParameterSummary object) {
                return Constants.INSTANCE.Remove();
            }
        };
        actionsColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<RequestParameterSummary, String>(){

            public void update(int index, RequestParameterSummary object, String value) {
                NewJobViewImpl.this.removeRow(index);
            }
        });
        actionsColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.myParametersGrid.addColumn((Column)actionsColumn, this.constants.Actions());
        this.myParametersGrid.setColumnWidth((Column)actionsColumn, 105.0, Style.Unit.PX);
        this.dataProvider.addDataDisplay(this.myParametersGrid);
    }

    public void addNewParameter() {
        this.addRow(new RequestParameterSummary(this.constants.ClickToEdit(), this.constants.ClickToEdit()));
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"run-now"})
    public void onRunNow(@ForEvent(value={"change"}) Event event) {
        this.selectedDate = new Date();
        this.dateFiltersInput.setHidden(true);
    }

    @EventHandler(value={"run-later"})
    public void onRunLater(@ForEvent(value={"change"}) Event event) {
        this.dateFiltersInput.setHidden(false);
        this.dateRangePicker.getElement().setAttribute("placeholder", DateUtils.getDateTimeStr((Date)this.selectedDate));
        this.resetDateTimePicker();
    }

    @EventHandler(value={"start"})
    public void onCreateClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.presenter.createJob(this.jobNameInput.getValue(), this.selectedDate, this.jobTypeInput.getValue(), this.jobRetriesInput.getValue(), this.dataProvider.getList());
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"advanced-tab"})
    public void onAdvancedTabMouseUp(@ForEvent(value={"mouseup"}) MouseEvent event) {
        if (this.redrawParametersGrid) {
            this.myParametersGrid.redraw();
            this.redrawParametersGrid = false;
        }
    }
}

