/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsManager;
import org.jbpm.workbench.es.client.editors.errordetails.ExecutionErrorDetailsPresenter;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListFilterSettingsManager;
import org.jbpm.workbench.es.client.editors.events.ExecutionErrorSelectedEvent;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.ExecutionErrorType;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ExecutionErrorListScreen")
public class ExecutionErrorListPresenter
extends AbstractMultiGridPresenter<ExecutionErrorSummary, ExecutionErrorListView> {
    private final Constants constants = Constants.INSTANCE;
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Caller<ExecutorService> executorService;
    @Inject
    private Event<ExecutionErrorSelectedEvent> executionErrorSelectedEvent;

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_ExecutionErrors());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_ExecutionErrors(), detailLabel, "ExecutionErrorDetailsScreen");
    }

    protected DataSetReadyCallback getDataSetReadyCallback(final Integer startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && ExecutionErrorListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    ArrayList<ExecutionErrorSummary> visibleExecutionErrors = new ArrayList<ExecutionErrorSummary>();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        visibleExecutionErrors.add(ExecutionErrorListPresenter.this.createExecutionErrorSummaryFromDataSet(dataSet, i));
                    }
                    boolean lastPageExactCount = false;
                    if (dataSet.getRowCount() < ((ExecutionErrorListView)ExecutionErrorListPresenter.this.view).getListGrid().getPageSize()) {
                        lastPageExactCount = true;
                    }
                    ExecutionErrorListPresenter.this.updateDataOnCallback(visibleExecutionErrors, startRange, startRange + visibleExecutionErrors.size(), lastPageExactCount);
                }
            }
        };
    }

    protected ExecutionErrorSummary createExecutionErrorSummaryFromDataSet(DataSet dataSet, Integer index) {
        return new ExecutionErrorSummary(DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_TYPE", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"DEPLOYMENT_ID", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"PROCESS_INST_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"PROCESS_ID", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"ACTIVITY_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ACTIVITY_NAME", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"JOB_ID", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_MSG", (int)index), Short.valueOf(DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"ERROR_ACK", (int)index).shortValue()), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"ERROR_ACK_BY", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"ERROR_ACK_AT", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"ERROR_DATE", (int)index));
    }

    public void acknowledgeExecutionError(String executionErrorId, String deploymentId) {
        ((ExecutorService)this.executorService.call(nothing -> {
            ((ExecutionErrorListView)this.view).displayNotification(this.constants.ExecutionErrorAcknowledged(executionErrorId));
            this.refreshGrid();
        })).acknowledgeError(this.getSelectedServerTemplate(), deploymentId, new String[]{executionErrorId});
    }

    public void goToJob(ExecutionErrorSummary errorSummary) {
        this.navigateToPerspective("Requests", "jobId", errorSummary.getJobId().toString());
    }

    public Predicate<ExecutionErrorSummary> getAcknowledgeActionCondition() {
        return pis -> !pis.isAcknowledged();
    }

    public Predicate<ExecutionErrorSummary> getViewJobActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("Requests") && pis.getJobId() != null;
    }

    public Predicate<ExecutionErrorSummary> getViewProcessInstanceActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ProcessInstances") && pis.getProcessInstanceId() != null;
    }

    public Predicate<ExecutionErrorSummary> getViewTaskActionCondition() {
        return pis -> (this.isUserAuthorizedForPerspective("TaskAdmin") || this.isUserAuthorizedForPerspective("Tasks")) && pis.getActivityId() != null && ExecutionErrorType.TASK.getType().equals(pis.getType().getType());
    }

    public void goToProcessInstance(ExecutionErrorSummary errorSummary) {
        this.navigateToPerspective("ProcessInstances", "processInstanceId", errorSummary.getProcessInstanceId().toString());
    }

    public void goToTask(ExecutionErrorSummary errorSummary) {
        this.navigateToPerspective(this.isUserAuthorizedForPerspective("TaskAdmin") ? "TaskAdmin" : "Tasks", "taskId", errorSummary.getActivityId().toString());
    }

    public void bulkAcknowledge(List<ExecutionErrorSummary> execErrorsSelected) {
        if (execErrorsSelected == null || execErrorsSelected.isEmpty()) {
            return;
        }
        for (ExecutionErrorSummary selected : execErrorsSelected) {
            if (selected.isAcknowledged()) {
                ((ExecutionErrorListView)this.view).displayNotification("Error " + selected.getErrorId() + "is already acknowledge");
                continue;
            }
            this.acknowledgeExecutionError(selected.getErrorId(), selected.getDeploymentId());
        }
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void selectSummaryItem(ExecutionErrorSummary summary) {
        this.setupDetailBreadcrumb(this.constants.ExecutionErrorBreadcrumb(ExecutionErrorDetailsPresenter.getErrorDetailTitle(summary)));
        this.placeManager.goTo("ExecutionErrorDetailsScreen");
        this.executionErrorSelectedEvent.fire((Object)new ExecutionErrorSelectedEvent(this.getSelectedServerTemplate(), summary.getDeploymentId(), summary.getErrorId()));
    }

    @Inject
    public void setFilterSettingsManager(ExecutionErrorListFilterSettingsManager filterSettingsManager) {
        super.setFilterSettingsManager((FilterSettingsManager)filterSettingsManager);
    }

    @Inject
    public void setExecutorService(Caller<ExecutorService> executorService) {
        this.executorService = executorService;
    }

    public void setupActiveSearchFilters() {
        Optional isErrorAckSearch;
        Optional errorTypeSearch;
        Optional taskIdSearch;
        boolean isDefaultFilters = true;
        Optional processInstanceSearch = this.getSearchParameter("processInstanceId");
        if (processInstanceSearch.isPresent()) {
            String processInstanceId = (String)processInstanceSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)Integer.valueOf(processInstanceId)), this.constants.Process_Instance_Id(), processInstanceId, Integer.valueOf(processInstanceId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"PROCESS_INST_ID", (Comparable)v)));
            isDefaultFilters = false;
        }
        if ((taskIdSearch = this.getSearchParameter("taskId")).isPresent()) {
            String taskId = (String)taskIdSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"ACTIVITY_ID", (Comparable)Integer.valueOf(taskId)), this.constants.Task(), taskId, Integer.valueOf(taskId), v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"ACTIVITY_ID", (Comparable)v)));
            isDefaultFilters = false;
        }
        if ((errorTypeSearch = this.getSearchParameter("errorType")).isPresent()) {
            String errorType = (String)errorTypeSearch.get();
            this.addActiveFilter(FilterFactory.equalsTo((String)"ERROR_TYPE", (Comparable)((Object)errorType)), this.constants.Type(), errorType, errorType, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"ERROR_TYPE", (Comparable)((Object)v))));
            isDefaultFilters = false;
        }
        if ((isErrorAckSearch = this.getSearchParameter("isErrorAck")).isPresent()) {
            boolean isErrorAck = ((String)isErrorAckSearch.get()).equalsIgnoreCase(Boolean.toString(true));
            Integer errorAckValue = isErrorAck ? 1 : 0;
            String valueLabel = isErrorAck ? this.commonConstants.Yes() : this.commonConstants.No();
            this.addActiveFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)errorAckValue), this.constants.Acknowledged(), valueLabel, errorAckValue, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)v)));
            isDefaultFilters = false;
        }
        if (isDefaultFilters) {
            this.setupDefaultActiveSearchFilters();
        }
    }

    public void setupDefaultActiveSearchFilters() {
        this.addActiveFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)Integer.valueOf(0)), this.constants.Acknowledged(), this.commonConstants.No(), 0, v -> this.removeActiveFilter(FilterFactory.equalsTo((String)"ERROR_ACK", (Comparable)v)));
    }

    public void setExecutionErrorSelectedEvent(Event<ExecutionErrorSelectedEvent> executionErrorSelectedEvent) {
        this.executionErrorSelectedEvent = executionErrorSelectedEvent;
    }

    public static interface ExecutionErrorListView
    extends MultiGridView<ExecutionErrorSummary, ExecutionErrorListPresenter> {
    }
}

