/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.editors.quicknewjob.NewJobPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.editors.util.JobUtils;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListPresenterTest {
    private static final Long REQUEST_ID = 1L;
    private static final String PERSPECTIVE_ID = "Requests";
    private String datasetUId = "jbpmRequestList";
    private org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants;
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private RequestListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private ListTable<RequestSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<RequestChangedEvent> requestChangedEvent;
    @Mock
    private EventSourceMock<JobSelectedEvent> jobSelectedEventMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private UberfireBreadcrumbs breadcrumbs;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private PerspectiveActivity perspectiveActivity;
    @Mock
    private ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Mock
    private NewJobPresenter newJobPresenterMock;
    @Mock
    private DataSet dataSet;
    @Spy
    private FilterSettings filterSettings;
    @Mock
    private ManagedInstance<ErrorHandlerBuilder> errorHandlerBuilder;
    private RequestListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        this.filterSettings.setKey("key");
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterSettings.getUUID()).thenReturn((Object)this.datasetUId);
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getView()).thenReturn(Mockito.mock(ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView.class));
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivity);
        Mockito.when((Object)this.perspectiveActivity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((DataSetQueryHelper)Mockito.doAnswer(invocation -> {
            ((DataSetReadyCallback)invocation.getArguments()[1]).callback(this.dataSet);
            return null;
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
        Mockito.when((Object)this.errorHandlerBuilder.get()).thenReturn((Object)new ErrorHandlerBuilder());
        this.presenter = new RequestListPresenter(this.viewMock, this.callerMockExecutorService, this.dataSetQueryHelper, this.requestChangedEvent, this.jobSelectedEventMock, this.placeManager);
        this.presenter.setUberfireBreadcrumbs(this.breadcrumbs);
        this.presenter.setPerspectiveManager(this.perspectiveManager);
        this.presenter.setServerTemplateSelectorMenuBuilder(this.serverTemplateSelectorMenuBuilder);
        this.presenter.setNewJobPresenter(this.newJobPresenterMock);
        this.presenter.setErrorHandlerBuilder(this.errorHandlerBuilder);
    }

    @Test
    public void getDataTest() {
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void cancelRequestTest() {
        this.presenter.cancelRequest(null, REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (String)Mockito.eq(null), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void requeueRequestTest() {
        this.presenter.requeueRequest(null, REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (String)Mockito.eq(null), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void cancelRequestTestWithDeploymentId() {
        this.presenter.cancelRequest("test", REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (String)Mockito.eq((Object)"test"), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void requeueRequestTestWithDeploymentId() {
        this.presenter.requeueRequest("test", REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (String)Mockito.eq((Object)"test"), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void testGetRequestSummary() {
        Long id = 1L;
        String message = "message";
        String status = "DONE";
        String commandName = "commandName";
        String businessKey = "businessKey";
        Integer retries = 2;
        Integer executions = 1;
        Date time = new Date();
        String processName = "myProcessName";
        Long processInstanceId = 33L;
        String processInstanceDescription = "myProcessInstanceDescription";
        String deploymentId = "test";
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        Mockito.when((Object)dataSet.getValueAt(0, "id")).thenReturn((Object)id);
        Mockito.when((Object)dataSet.getValueAt(0, "timestamp")).thenReturn((Object)time);
        Mockito.when((Object)dataSet.getValueAt(0, "status")).thenReturn((Object)"DONE");
        Mockito.when((Object)dataSet.getValueAt(0, "commandName")).thenReturn((Object)"commandName");
        Mockito.when((Object)dataSet.getValueAt(0, "message")).thenReturn((Object)"message");
        Mockito.when((Object)dataSet.getValueAt(0, "businessKey")).thenReturn((Object)"businessKey");
        Mockito.when((Object)dataSet.getValueAt(0, "retries")).thenReturn((Object)retries);
        Mockito.when((Object)dataSet.getValueAt(0, "executions")).thenReturn((Object)executions);
        Mockito.when((Object)dataSet.getValueAt(0, "processName")).thenReturn((Object)"myProcessName");
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)processInstanceId);
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceDescription")).thenReturn((Object)"myProcessInstanceDescription");
        Mockito.when((Object)dataSet.getValueAt(0, "deploymentId")).thenReturn((Object)"test");
        RequestSummary rs = this.presenter.getRequestSummary(dataSet, Integer.valueOf(0));
        Assert.assertEquals((Object)id, (Object)rs.getId());
        Assert.assertEquals((Object)time, (Object)rs.getTime());
        Assert.assertEquals((Object)RequestStatus.DONE, (Object)rs.getStatus());
        Assert.assertEquals((Object)"commandName", (Object)rs.getCommandName());
        Assert.assertEquals((Object)"message", (Object)rs.getMessage());
        Assert.assertEquals((Object)"businessKey", (Object)rs.getKey());
        Assert.assertEquals((Object)retries, (Object)rs.getRetries());
        Assert.assertEquals((Object)executions, (Object)rs.getExecutions());
        Assert.assertEquals((Object)"myProcessName", (Object)rs.getProcessName());
        Assert.assertEquals((Object)processInstanceId, (Object)rs.getProcessInstanceId());
        Assert.assertEquals((Object)"myProcessInstanceDescription", (Object)rs.getProcessInstanceDescription());
        Assert.assertEquals((Object)"test", (Object)rs.getDeploymentId());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.Status(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.Status() + ": " + Constants.INSTANCE.Running()), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)RequestStatus.RUNNING.name(), (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)Constants.INSTANCE.Status(), (Object)((ActiveFilterItem)captor.getValue()).getKey());
        Assert.assertEquals((Object)(Constants.INSTANCE.Status() + ": " + Constants.INSTANCE.Running()), (Object)((ActiveFilterItem)captor.getValue()).getLabelValue());
        Assert.assertEquals((Object)RequestStatus.RUNNING.name(), (Object)((ActiveFilterItem)captor.getValue()).getValue());
    }

    @Test
    public void testStatusActionConditionPredicates() {
        RequestStatus[] CANCEL_ALLOW_STATUSES = new RequestStatus[]{RequestStatus.QUEUED, RequestStatus.RETRYING, RequestStatus.RUNNING};
        RequestStatus[] REQUEUE_ALLOW_STATUSES = new RequestStatus[]{RequestStatus.ERROR, RequestStatus.RUNNING};
        RequestSummary testJob = new RequestSummary();
        for (RequestStatus status : RequestStatus.values()) {
            testJob.setStatus(status);
            Assert.assertEquals((Object)Arrays.asList(CANCEL_ALLOW_STATUSES).contains(status), (Object)this.presenter.getCancelActionCondition().test(testJob));
            Assert.assertEquals((Object)Arrays.asList(REQUEUE_ALLOW_STATUSES).contains(status), (Object)this.presenter.getRequeueActionCondition().test(testJob));
        }
    }

    @Test
    public void testViewProcessActionConditionPredicates() {
        RequestSummary testJob = new RequestSummary();
        testJob.setProcessInstanceId(Long.valueOf(33L));
        Assert.assertTrue((boolean)this.presenter.getViewProcessActionCondition().test(testJob));
        testJob.setProcessInstanceId(null);
        Assert.assertFalse((boolean)this.presenter.getViewProcessActionCondition().test(testJob));
        Assert.assertFalse((boolean)this.presenter.getViewProcessActionCondition().test(new RequestSummary()));
    }

    @Test
    public void testJobSelectionWithDetailsClosed() {
        RequestSummary job = JobUtils.createRequestSummary();
        this.presenter.selectSummaryItem(job);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("JobDetailsScreen");
        ArgumentCaptor captor = ArgumentCaptor.forClass(JobSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.jobSelectedEventMock)).fire(captor.capture());
        this.assertJobSelectedEventContent((JobSelectedEvent)captor.getValue(), job.getDeploymentId(), (Long)job.getId());
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)Constants.INSTANCE.JobBreadcrumb((Long)job.getId())), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
    }

    @Test
    public void testJobSelectionWithDetailsOpen() {
        RequestSummary job = JobUtils.createRequestSummary();
        this.presenter.selectSummaryItem(job);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(JobSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.jobSelectedEventMock)).fire(captor.capture());
        this.assertJobSelectedEventContent((JobSelectedEvent)captor.getValue(), job.getDeploymentId(), (Long)job.getId());
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateNull() {
        this.presenter.setSelectedServerTemplate(null);
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification("SelectServerTemplate");
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock, (VerificationMode)Mockito.never())).openNewJobDialog(Mockito.anyString());
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateEmpty() {
        Assert.assertTrue((boolean)this.presenter.getSelectedServerTemplate().isEmpty());
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification("SelectServerTemplate");
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock, (VerificationMode)Mockito.never())).openNewJobDialog(Mockito.anyString());
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateSet() {
        String serverTemplateTest = "serverTemplateTest";
        this.presenter.setSelectedServerTemplate(new ServerTemplate("serverTemplateTest", null, Collections.singletonList(Capability.PROCESS.name()), Collections.emptyMap(), Collections.emptyList()));
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        Assert.assertEquals((Object)"serverTemplateTest", (Object)this.presenter.getSelectedServerTemplate());
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock)).openNewJobDialog("serverTemplateTest");
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)3))).getListGrid();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).clearBlockingError();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.viewMock});
    }

    @Test
    public void testListBreadcrumbCreation() {
        this.presenter.createListBreadcrumb();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Jobs()), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbs});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, this.commonConstants.Manage_Jobs(), detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Jobs()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)detailLabel), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
    }

    private void assertJobSelectedEventContent(JobSelectedEvent event, String deploymentId, Long jobId) {
        Assert.assertEquals((Object)jobId, (Object)event.getJobId());
        Assert.assertEquals((Object)deploymentId, (Object)event.getDeploymentId());
    }

    @Test
    public void testOnBasicFilterAddEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.presenter.onBasicFilterAddEvent(new BasicFilterAddEvent(this.datasetUId, filter, columnFilter));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).addColumnFilter(columnFilter);
    }

    @Test
    public void testOnBasicFilterRemoveEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.presenter.onBasicFilterRemoveEvent(new BasicFilterRemoveEvent(this.datasetUId, filter, columnFilter));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).removeActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).removeColumnFilter(columnFilter);
    }

    @Test
    public void bulkCancelJobsDependingOnStatusTest() {
        String serverTemplateTest = "serverTemplateTest";
        this.presenter.setSelectedServerTemplate(new ServerTemplate("serverTemplateTest", null));
        String deploymentId = "deploymentId";
        String key = "key";
        Long jobId_1 = new Random().nextLong();
        Long jobId_2 = jobId_1 + 1L;
        Long jobId_3 = jobId_2 + 1L;
        ArrayList<RequestSummary> requestSummaries = new ArrayList<RequestSummary>();
        requestSummaries.add(JobUtils.createRequestSummary(jobId_1, key, deploymentId, RequestStatus.QUEUED));
        requestSummaries.add(JobUtils.createRequestSummary(jobId_2, key, deploymentId, RequestStatus.RUNNING));
        requestSummaries.add(JobUtils.createRequestSummary(jobId_3, key, deploymentId, RequestStatus.ERROR));
        this.presenter.bulkCancel(requestSummaries);
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_1));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_2));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock, (VerificationMode)Mockito.never())).cancelRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_3));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.RequestCanceled(jobId_1));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.RequestCanceled(jobId_2));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.Job_Can_Not_Be_Cancelled(jobId_3));
    }

    @Test
    public void bulkRequeueJobsDependingOnStatusTest() {
        String serverTemplateTest = "serverTemplateTest";
        this.presenter.setSelectedServerTemplate(new ServerTemplate("serverTemplateTest", null));
        String deploymentId = "deploymentId";
        String key = "key";
        Long jobId_1 = new Random().nextLong();
        Long jobId_2 = jobId_1 + 1L;
        Long jobId_3 = jobId_2 + 1L;
        ArrayList<RequestSummary> requestSummaries = new ArrayList<RequestSummary>();
        requestSummaries.add(JobUtils.createRequestSummary(jobId_1, key, deploymentId, RequestStatus.ERROR));
        requestSummaries.add(JobUtils.createRequestSummary(jobId_2, key, deploymentId, RequestStatus.RUNNING));
        requestSummaries.add(JobUtils.createRequestSummary(jobId_3, key, deploymentId, RequestStatus.QUEUED));
        this.presenter.bulkRequeue(requestSummaries);
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_1));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_2));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock, (VerificationMode)Mockito.never())).requeueRequest(Mockito.anyString(), Mockito.anyString(), (Long)Mockito.eq((Object)jobId_3));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.RequestRequeued(jobId_1));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.RequestRequeued(jobId_2));
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification(Constants.INSTANCE.Job_Can_Not_Be_Requeued(jobId_3));
    }
}

