/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.util;

import java.util.Date;
import org.jbpm.workbench.es.model.ErrorSummary;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.util.RequestStatus;

public class JobUtils {
    private static final Long JOB_ID = 1L;
    private static final Long PROCESS_INSTANCE_ID = 2L;

    public static RequestSummary createRequestSummary() {
        return JobUtils.createRequestSummary(JOB_ID, "businessKey", RequestStatus.QUEUED);
    }

    public static RequestSummary createRequestSummary(RequestStatus status) {
        return JobUtils.createRequestSummary(JOB_ID, "businessKey", status);
    }

    public static RequestSummary createRequestSummary(Long jobId, String businessKey, RequestStatus status) {
        return JobUtils.createRequestSummary(jobId, businessKey, "evaluation.1.0.1", status);
    }

    public static RequestSummary createRequestSummary(Long jobId, String businessKey, String deploymentId, RequestStatus status) {
        return new RequestSummary(jobId, new Date(), status, "commandName", "Message", businessKey, Integer.valueOf(1), Integer.valueOf(0), "testProcessName", PROCESS_INSTANCE_ID, "testProcessInstanceDescription", deploymentId);
    }

    public static ErrorSummary createErrorSummary() {
        return new ErrorSummary(Long.valueOf(3L), new Date(), "errorMessage", "errorStacktrace", JOB_ID);
    }

    public static RequestParameterSummary createRequestParameterSummary() {
        return new RequestParameterSummary("processInstanceId", Long.toString(PROCESS_INSTANCE_ID));
    }
}

