/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.client.util.JobStatusConverter;
import org.jbpm.workbench.es.model.RequestSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractMultiGridView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private JobStatusConverter jobStatusConverter;
    @Inject
    private ConfirmPopup confirmPopup;

    public List<String> getInitColumns() {
        return Arrays.asList("Select", "id", "businessKey", "commandName", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("Select", "id", "commandName", "Actions");
    }

    public void initColumns(ListTable extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        extendedPagedTable.addSelectionIgnoreColumn(checkColumnMeta.getColumn());
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createNumberColumn("id", req -> req.getJobId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("businessKey", req -> req.getKey()), this.constants.BusinessKey()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("commandName", req -> req.getCommandName()), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", req -> this.jobStatusConverter.toWidgetValue(req.getStatus())), this.constants.Status()));
        Column timestampColumn = this.createTextColumn("timestamp", req -> DateUtils.getDateTimeStr((Date)req.getTime()));
        timestampColumn.setDefaultSortAscending(false);
        columnMetas.add(new ColumnMeta(timestampColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", req -> req.getProcessName()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", req -> req.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", req -> req.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 175.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(timestampColumn);
    }

    public String getEmptyTableCaption() {
        return this.constants.No_Jobs_Found();
    }

    public List<AnchorListItem> getBulkActionsItems(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        ArrayList<AnchorListItem> bulkActionsItems = new ArrayList<AnchorListItem>();
        bulkActionsItems.add(this.getBulkCancel(extendedPagedTable));
        bulkActionsItems.add(this.getBulkRequeue(extendedPagedTable));
        return bulkActionsItems;
    }

    protected List<ConditionalAction<RequestSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Cancel(), job -> this.confirmPopup.show(this.constants.Cancel_Job_Confirmation(), this.constants.Cancel_Job(), this.constants.Cancel_Job_Sure(), () -> ((RequestListPresenter)this.presenter).cancelRequest(job.getDeploymentId(), job.getJobId())), ((RequestListPresenter)this.presenter).getCancelActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Requeue(), job -> this.confirmPopup.show(this.constants.Requeue_Job_Confirmation(), this.constants.Requeue_Job(), this.constants.Requeue_Job_Sure(), () -> ((RequestListPresenter)this.presenter).requeueRequest(job.getDeploymentId(), job.getJobId())), ((RequestListPresenter)this.presenter).getRequeueActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.ViewProcessInstance(), job -> ((RequestListPresenter)this.presenter).openProcessInstanceView(Long.toString(job.getProcessInstanceId())), ((RequestListPresenter)this.presenter).getViewProcessActionCondition(), Boolean.valueOf(true)));
    }

    protected AnchorListItem getBulkCancel(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        AnchorListItem bulkAbortNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAbortNavLink.setText(this.constants.Bulk_Cancel_jobs());
        bulkAbortNavLink.setIcon(IconType.TIMES_CIRCLE_O);
        bulkAbortNavLink.setIconFixedWidth(true);
        bulkAbortNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Cancel_Jobs_Confirmation(), this.constants.Cancel_Jobs(), this.constants.Cancel_Jobs_Sure(), this.getCancelCommand(extendedPagedTable)));
        return bulkAbortNavLink;
    }

    protected AnchorListItem getBulkRequeue(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        AnchorListItem bulkAbortNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAbortNavLink.setText(this.constants.Bulk_Requeue_jobs());
        bulkAbortNavLink.setIcon(IconType.HISTORY);
        bulkAbortNavLink.setIconFixedWidth(true);
        bulkAbortNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Requeue_Jobs_Confirmation(), this.constants.Requeue_Jobs(), this.constants.Requeue_Jobs_Sure(), this.getRequeueCommand(extendedPagedTable)));
        return bulkAbortNavLink;
    }

    protected Command getCancelCommand(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        return () -> {
            ((RequestListPresenter)this.presenter).bulkCancel(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
        };
    }

    protected Command getRequeueCommand(ExtendedPagedTable<RequestSummary> extendedPagedTable) {
        return () -> {
            ((RequestListPresenter)this.presenter).bulkRequeue(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
        };
    }
}

