/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.es.client.editors.requestlist.JobListFilterSettingsManager;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class JobListFilterSettingsManagerTest {
    @Mock
    UserPreferencesService userPreferencesService;
    @Mock
    FilterSettingsJSONMarshaller marshaller;
    Caller<UserPreferencesService> preferencesService;
    @InjectMocks
    JobListFilterSettingsManager manager;

    @Before
    public void init() {
        this.preferencesService = new CallerMock((Object)this.userPreferencesService);
        this.manager.setPreferencesService(this.preferencesService);
    }

    @Test
    public void testDefaultFilters() {
        Consumer<List> callback = filters -> {
            Assert.assertEquals((long)6L, (long)filters.size());
            Assert.assertEquals((Object)Constants.INSTANCE.Queued(), (Object)((SavedFilter)filters.get(0)).getName());
            Assert.assertEquals((Object)"DS_RequestListGrid_base", (Object)((SavedFilter)filters.get(1)).getKey());
            Assert.assertEquals((Object)Constants.INSTANCE.Running(), (Object)((SavedFilter)filters.get(1)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Retrying(), (Object)((SavedFilter)filters.get(2)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Error(), (Object)((SavedFilter)filters.get(3)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Completed(), (Object)((SavedFilter)filters.get(4)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Canceled(), (Object)((SavedFilter)filters.get(5)).getName());
        };
        MultiGridPreferencesStore store = new MultiGridPreferencesStore();
        this.manager.loadSavedFiltersFromPreferences(store, callback);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesService)).saveUserPreferences((UserPreference)store);
    }
}

