/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.errorlist;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.BooleanConverter;
import org.jbpm.workbench.common.client.util.ConditionalButtonActionCell;
import org.jbpm.workbench.common.client.util.DateTimeConverter;
import org.jbpm.workbench.es.client.editors.errorlist.ExecutionErrorListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.client.util.ExecutionErrorTypeConverter;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class ExecutionErrorListViewImpl
extends AbstractMultiGridView<ExecutionErrorSummary, ExecutionErrorListPresenter>
implements ExecutionErrorListPresenter.ExecutionErrorListView {
    private static final String EXECUTION_ERROR_LIST_PREFIX = "DS_ExecutionErrorListGrid";
    protected static final String TAB_ALL = "DS_ExecutionErrorListGrid_0";
    protected static final String TAB_ACK = "DS_ExecutionErrorListGrid_1";
    protected static final String TAB_NEW = "DS_ExecutionErrorListGrid_2";
    private final Constants constants = Constants.INSTANCE;
    @Inject
    ConfirmPopup confirmPopup;
    @Inject
    ExecutionErrorTypeConverter executionErrorTypeConverter;
    @Inject
    DateTimeConverter dateTimeConverter;
    @Inject
    BooleanConverter booleanConverter;

    public List<String> getInitColumns() {
        return Arrays.asList("Select", "ERROR_TYPE", "PROCESS_INST_ID", "ERROR_DATE", "DEPLOYMENT_ID", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("Select", "ERROR_TYPE", "PROCESS_INST_ID", "ERROR_DATE", "Actions");
    }

    public String getGridGlobalPreferencesKey() {
        return EXECUTION_ERROR_LIST_PREFIX;
    }

    public String getNewFilterPopupTitle() {
        return this.constants.New_ErrorList();
    }

    public void initSelectionModel(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Execution_Errors_Found());
        extendedPagedTable.setSelectionCallback((error, close) -> ((ExecutionErrorListPresenter)this.presenter).selectExecutionError((ExecutionErrorSummary)error, (Boolean)close));
        this.initBulkActions(extendedPagedTable);
    }

    private void initBulkActions(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        extendedPagedTable.getRightActionsToolbar().clear();
        AnchorListItem bulkAckNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAckNavLink.setText(this.constants.Bulk_Ack());
        ButtonGroup bulkActions = (ButtonGroup)GWT.create(ButtonGroup.class);
        Button bulkButton = (Button)GWT.create(Button.class);
        bulkButton.setText(this.constants.Bulk_Actions());
        bulkButton.setDataToggle(Toggle.DROPDOWN);
        bulkButton.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkActions.add((Widget)bulkButton);
        DropDownMenu bulkDropDown = (DropDownMenu)GWT.create(DropDownMenu.class);
        bulkDropDown.addStyleName("dropdown-menu-right");
        bulkDropDown.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        bulkDropDown.add((Widget)bulkAckNavLink);
        bulkActions.add((Widget)bulkDropDown);
        bulkAckNavLink.setIcon(IconType.BAN);
        bulkAckNavLink.setIconFixedWidth(true);
        bulkAckNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Bulk_Ack(), this.constants.Acknowledge(), this.constants.Bulk_Ack_confirm(), () -> {
            ((ExecutionErrorListPresenter)this.presenter).bulkAcknowledge(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
            extendedPagedTable.redraw();
        }));
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
    }

    public void initColumns(ExtendedPagedTable<ExecutionErrorSummary> extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ID", errorSummary -> errorSummary.getErrorId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_TYPE", errorSummary -> this.executionErrorTypeConverter.toWidgetValue(errorSummary.getType())), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK", errorSummary -> this.booleanConverter.toWidgetValue(Boolean.valueOf(errorSummary.isAcknowledged()))), this.constants.Ack()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_AT", errorSummary -> this.dateTimeConverter.toWidgetValue(errorSummary.getAcknowledgedAt())), this.constants.AckAt()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_ACK_BY", errorSummary -> errorSummary.getAcknowledgedBy()), this.constants.AckBy()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("JOB_ID", errorSummary -> errorSummary.getJobId()), this.constants.JobId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("PROCESS_ID", errorSummary -> errorSummary.getProcessId()), this.constants.ProcessId()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("PROCESS_INST_ID", errorSummary -> errorSummary.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("ACTIVITY_ID", errorSummary -> errorSummary.getActivityId()), this.constants.ActivityId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ACTIVITY_NAME", errorSummary -> errorSummary.getActivityName()), this.constants.ActivityName()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_DATE", errorSummary -> this.dateTimeConverter.toWidgetValue(errorSummary.getErrorDate())), this.constants.ErrorDate()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("DEPLOYMENT_ID", errorSummary -> errorSummary.getDeploymentId()), this.constants.DeploymentId()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("ERROR_MSG", errorSummary -> errorSummary.getErrorMessage()), this.constants.Message()));
        Column<ExecutionErrorSummary, ExecutionErrorSummary> actionsColumn = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumn);
        ColumnMeta actionsColumnMeta = new ColumnMeta(actionsColumn, this.constants.Actions());
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 340.0, Style.Unit.PX);
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column<ExecutionErrorSummary, ExecutionErrorSummary> initActionsColumn() {
        LinkedList<ConditionalButtonActionCell> cells = new LinkedList<ConditionalButtonActionCell>();
        cells.add(new ConditionalButtonActionCell(this.constants.Acknowledge(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).acknowledgeExecutionError(errorSummary.getErrorId(), errorSummary.getDeploymentId()), ((ExecutionErrorListPresenter)this.presenter).getAcknowledgeActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewProcessInstance(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToProcessInstance((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewProcessInstanceActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewJob(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToJob((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewJobActionCondition()));
        cells.add(new ConditionalButtonActionCell(this.constants.ViewTask(), errorSummary -> ((ExecutionErrorListPresenter)this.presenter).goToTask((ExecutionErrorSummary)errorSummary), ((ExecutionErrorListPresenter)this.presenter).getViewTaskActionCondition()));
        CompositeCell cell = new CompositeCell(cells);
        Column<ExecutionErrorSummary, ExecutionErrorSummary> actionsColumn = new Column<ExecutionErrorSummary, ExecutionErrorSummary>((Cell)cell){

            public ExecutionErrorSummary getValue(ExecutionErrorSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    public void initDefaultFilters() {
        super.initDefaultFilters();
        this.initTabFilter(((ExecutionErrorListPresenter)this.presenter).createAllTabSettings(), TAB_ALL, this.constants.All(), this.constants.FilterAll(), "jbpmExecutionErrorList");
        this.initTabFilter(((ExecutionErrorListPresenter)this.presenter).createNewTabSettings(), TAB_NEW, this.constants.New(), this.constants.UnacknowledgedErrors(), "jbpmExecutionErrorList");
        this.initTabFilter(((ExecutionErrorListPresenter)this.presenter).createAcknowledgedTabSettings(), TAB_ACK, this.constants.Acknowledged(), this.constants.AcknowledgedErrors(), "jbpmExecutionErrorList");
    }
}

