/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.jobdetails;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.TextArea;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.databinding.client.components.ListContainer;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.Bundle;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.es.client.editors.jobdetails.JobBasicDetailsViewImpl;
import org.jbpm.workbench.es.client.editors.jobdetails.JobDetailsPresenter;
import org.jbpm.workbench.es.client.editors.jobdetails.JobParameterListViewImpl;
import org.jbpm.workbench.es.model.ErrorSummary;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.uberfire.client.mvp.PlaceManager;

@Dependent
@Templated
@Bundle(value="/org/jbpm/workbench/es/client/i18n/Constants.properties")
public class JobDetailsViewImpl
implements JobDetailsPresenter.JobDetailsView {
    @Inject
    @DataField(value="container")
    Div container;
    @Inject
    @DataField(value="job-details")
    JobBasicDetailsViewImpl basicJobDetails;
    @Inject
    @DataField(value="job-errors")
    TextArea jobErrorTextArea;
    @Inject
    @DataField(value="errorControlGroup")
    Div errorControlGroup;
    @Inject
    PlaceManager placeManager;
    @Inject
    @DataField(value="params-form-group")
    private Div paramsFormGroup;
    @Inject
    @Bound
    @ListContainer(value="tbody")
    @DataField(value="job-params")
    private ListComponent<RequestParameterSummary, JobParameterListViewImpl> jobParameters;
    @Inject
    @AutoBound
    private DataBinder<List<RequestParameterSummary>> jobParameterList;

    public void init(JobDetailsPresenter presenter) {
    }

    @Override
    public void setBasicDetails(RequestSummary requestSummary) {
        this.basicJobDetails.setValue(requestSummary);
        this.errorControlGroup.setHidden(true);
    }

    @Override
    public void setParameters(List<RequestParameterSummary> requestParameterSummaries) {
        if (requestParameterSummaries.size() > 0) {
            DOMUtil.removeCSSClass((HTMLElement)this.paramsFormGroup, (String)"hidden");
        }
        this.jobParameterList.setModel(requestParameterSummaries);
    }

    @Override
    public void setErrors(List<ErrorSummary> errors) {
        this.errorControlGroup.setHidden(false);
        String textAreaContent = "";
        for (ErrorSummary error : errors) {
            textAreaContent = textAreaContent + error.getMessage() + "\n" + error.getStacktrace() + "\n\n";
        }
        this.jobErrorTextArea.setText(textAreaContent);
    }

    public HTMLElement getElement() {
        return this.container;
    }
}

