/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.editors.quicknewjob.QuickNewJobPopup;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Job List")
public class RequestListPresenter
extends AbstractMultiGridPresenter<RequestSummary, RequestListView> {
    public static final String SCREEN_ID = "Job List";
    private Constants constants = Constants.INSTANCE;
    @Inject
    private Caller<ExecutorService> executorServices;
    @Inject
    private Event<RequestChangedEvent> requestChangedEvent;
    @Inject
    private QuickNewJobPopup quickNewJobPopup;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private Event<JobSelectedEvent> jobSelectedEvent;

    public RequestListPresenter() {
    }

    public RequestListPresenter(RequestListViewImpl view, Caller<ExecutorService> executorServices, DataSetQueryHelper dataSetQueryHelper, Event<RequestChangedEvent> requestChangedEvent, Event<JobSelectedEvent> jobSelectedEvent, PlaceManager placeManager) {
        this.view = view;
        this.executorServices = executorServices;
        this.dataSetQueryHelper = dataSetQueryHelper;
        this.requestChangedEvent = requestChangedEvent;
        this.jobSelectedEvent = jobSelectedEvent;
        this.placeManager = placeManager;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Jobs();
    }

    public void getData(final Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                final FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
                currentTableSettings.setTablePageSize(((RequestListView)this.view).getListGrid().getPageSize());
                ColumnSortList columnSortList = ((RequestListView)this.view).getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("timestamp");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), (DataSetReadyCallback)new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, currentTableSettings.getUUID()){

                    public void callback(DataSet dataSet) {
                        if (dataSet != null && RequestListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                            ArrayList<RequestSummary> myRequestSumaryFromDataSet = new ArrayList<RequestSummary>();
                            for (int i = 0; i < dataSet.getRowCount(); ++i) {
                                myRequestSumaryFromDataSet.add(RequestListPresenter.this.getRequestSummary(dataSet, i));
                            }
                            boolean lastPageExactCount = false;
                            if (dataSet.getRowCount() < ((RequestListView)RequestListPresenter.this.view).getListGrid().getPageSize()) {
                                lastPageExactCount = true;
                            }
                            RequestListPresenter.this.updateDataOnCallback(myRequestSumaryFromDataSet, visibleRange.getStart(), visibleRange.getStart() + myRequestSumaryFromDataSet.size(), lastPageExactCount);
                        }
                    }
                });
                ((RequestListView)this.view).hideBusyIndicator();
            }
        }
        catch (Exception e) {
            ((RequestListView)this.view).displayNotification(this.constants.ErrorRetrievingJobs(e.getMessage()));
            GWT.log((String)"Error looking up dataset with UUID [ jbpmRequestList ]");
        }
    }

    protected RequestSummary getRequestSummary(DataSet dataSet, Integer index) {
        return new RequestSummary(DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"id", (int)index), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"timestamp", (int)index), RequestStatus.valueOf((String)DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"status", (int)index)), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"commandName", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"message", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"businessKey", (int)index), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"retries", (int)index), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"executions", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processName", (int)index), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processInstanceDescription", (int)index), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"deploymentId", (int)index));
    }

    public void cancelRequest(String deploymentId, final Long requestId) {
        ((ExecutorService)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((RequestListView)RequestListPresenter.this.view).displayNotification(RequestListPresenter.this.constants.RequestCanceled(requestId));
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).cancelRequest(this.getSelectedServerTemplate(), deploymentId, requestId);
    }

    public void requeueRequest(String deploymentId, final Long requestId) {
        ((ExecutorService)this.executorServices.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                ((RequestListView)RequestListPresenter.this.view).displayNotification(RequestListPresenter.this.constants.RequestRequeued(requestId));
                RequestListPresenter.this.requestChangedEvent.fire((Object)new RequestChangedEvent(requestId));
            }
        })).requeueRequest(this.getSelectedServerTemplate(), deploymentId, requestId);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.constants.New_Job()).respondsWith(new Command(){

            public void execute() {
                String selectedServerTemplate = RequestListPresenter.this.getSelectedServerTemplate();
                if (selectedServerTemplate == null || selectedServerTemplate.trim().isEmpty()) {
                    ((RequestListView)RequestListPresenter.this.view).displayNotification(RequestListPresenter.this.constants.SelectServerTemplate());
                } else {
                    RequestListPresenter.this.quickNewJobPopup.show(selectedServerTemplate);
                }
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    public void selectJob(RequestSummary job, Boolean close) {
        if (job.getStatus() != null) {
            PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Job Details"));
            if (status == PlaceStatus.CLOSE) {
                this.placeManager.goTo("Job Details");
                this.jobSelectedEvent.fire((Object)new JobSelectedEvent(this.getSelectedServerTemplate(), job.getDeploymentId(), job.getJobId()));
            } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
                this.jobSelectedEvent.fire((Object)new JobSelectedEvent(this.getSelectedServerTemplate(), job.getDeploymentId(), job.getJobId()));
            } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
                this.placeManager.closePlace("Job Details");
            }
        }
    }

    public void requestCreated(@Observes RequestChangedEvent event) {
        this.refreshGrid();
    }

    public void setupAdvancedSearchView() {
        ((RequestListView)this.view).addNumericFilter(this.constants.Process_Instance_Id(), this.constants.FilterByProcessInstanceId(), v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))));
        ((RequestListView)this.view).addTextFilter(this.constants.BusinessKey(), this.constants.FilterByBusinessKey(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"businessKey", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"businessKey", (String)v, (boolean)false)));
        ((RequestListView)this.view).addTextFilter(this.constants.Type(), this.constants.FilterByType(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"commandName", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"commandName", (String)v, (boolean)false)));
        ((RequestListView)this.view).addTextFilter(this.constants.Process_Instance_Description(), this.constants.FilterByProcessDescription(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"processInstanceDescription", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"processInstanceDescription", (String)v, (boolean)false)));
        HashMap<String, String> status = new HashMap<String, String>();
        status.put(RequestStatus.CANCELLED.name(), this.constants.Canceled());
        status.put(RequestStatus.DONE.name(), this.constants.Completed());
        status.put(RequestStatus.ERROR.name(), this.constants.Error());
        status.put(RequestStatus.QUEUED.name(), this.constants.Queued());
        status.put(RequestStatus.RETRYING.name(), this.constants.Retrying());
        status.put(RequestStatus.RUNNING.name(), this.constants.Running());
        ((RequestListView)this.view).addSelectFilter(this.constants.Status(), status, false, v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmRequestList")).group("processName")).column("processName")).sort("processName", SortOrder.ASCENDING)).buildLookup();
        ((RequestListView)this.view).addDataSetSelectFilter(this.constants.Process_Name(), "base", dataSetLookup, "processName", "processName", v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processName", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processName", (Comparable)((Object)v))));
        ((RequestListView)this.view).addDateRangeFilter(this.constants.Due_On(), this.constants.Due_On_Placeholder(), false, v -> this.addAdvancedSearchFilter(FilterFactory.between((String)"timestamp", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())), v -> this.removeAdvancedSearchFilter(FilterFactory.between((String)"timestamp", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())));
    }

    public void setupActiveSearchFilters() {
        Optional processInstIdSearch = this.getSearchParameter("processInstanceId");
        if (processInstIdSearch.isPresent()) {
            String processInstId = (String)processInstIdSearch.get();
            ((RequestListView)this.view).addActiveFilter(this.constants.Process_Instance_Id(), processInstId, processInstId, v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))));
            this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)processInstId)));
        } else {
            Optional jobSearch = this.getSearchParameter("jobId");
            if (jobSearch.isPresent()) {
                String jobId = (String)jobSearch.get();
                ((RequestListView)this.view).addActiveFilter(this.constants.JobId(), jobId, jobId, v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
                this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"id", (Comparable)((Object)jobId)));
            } else {
                this.setupDefaultActiveSearchFilters();
            }
        }
    }

    public void setupDefaultActiveSearchFilters() {
        ((RequestListView)this.view).addActiveFilter(this.constants.Status(), this.constants.Running(), RequestStatus.RUNNING.name(), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
        this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)RequestStatus.RUNNING));
    }

    public void openProcessInstanceView(String processInstanceId) {
        this.navigateToPerspective("ProcessInstances", "processInstanceId", processInstanceId);
    }

    public FilterSettings createTableSettingsPrototype() {
        return this.createStatusSettings(null);
    }

    private FilterSettings createStatusSettings(RequestStatus status) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmRequestList");
        if (status != null) {
            builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", (Comparable)((Object)status.name()))});
        }
        builder.setColumn("id", this.constants.Id());
        builder.setColumn("timestamp", this.constants.Time(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("commandName", this.constants.CommandName());
        builder.setColumn("message", this.constants.Message());
        builder.setColumn("businessKey", this.constants.Key());
        builder.setColumn("retries", this.constants.Retries());
        builder.setColumn("executions", this.constants.Executions());
        builder.setColumn("processName", this.constants.Process_Name());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processInstanceDescription", this.constants.Process_Instance_Description());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("timestamp", SortOrder.DESCENDING);
        return builder.buildSettings();
    }

    public FilterSettings createSearchTabSettings() {
        return this.createTableSettingsPrototype();
    }

    public FilterSettings createAllTabSettings() {
        return this.createStatusSettings(null);
    }

    public FilterSettings createQueuedTabSettings() {
        return this.createStatusSettings(RequestStatus.QUEUED);
    }

    public FilterSettings createRunningTabSettings() {
        return this.createStatusSettings(RequestStatus.RUNNING);
    }

    public FilterSettings createRetryingTabSettings() {
        return this.createStatusSettings(RequestStatus.RETRYING);
    }

    public FilterSettings createErrorTabSettings() {
        return this.createStatusSettings(RequestStatus.ERROR);
    }

    public FilterSettings createCompletedTabSettings() {
        return this.createStatusSettings(RequestStatus.DONE);
    }

    public FilterSettings createCanceledTabSettings() {
        return this.createStatusSettings(RequestStatus.CANCELLED);
    }

    public Predicate<RequestSummary> getCancelActionCondition() {
        return this.getActionConditionFromStatusList(new RequestStatus[]{RequestStatus.QUEUED, RequestStatus.RETRYING, RequestStatus.RUNNING});
    }

    public Predicate<RequestSummary> getRequeueActionCondition() {
        return this.getActionConditionFromStatusList(new RequestStatus[]{RequestStatus.ERROR, RequestStatus.RUNNING});
    }

    public Predicate<RequestSummary> getViewProcessActionCondition() {
        return job -> job.getProcessInstanceId() != null;
    }

    private Predicate<RequestSummary> getActionConditionFromStatusList(RequestStatus[] statusList) {
        return value -> Arrays.stream(statusList).anyMatch(s -> s.equals((Object)value.getStatus()));
    }

    public static interface RequestListView
    extends MultiGridView<RequestSummary, RequestListPresenter> {
    }
}

