/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.es.client.editors.events.JobSelectedEvent;
import org.jbpm.workbench.es.client.editors.quicknewjob.NewJobPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListViewImpl;
import org.jbpm.workbench.es.client.editors.util.JobUtils;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.model.events.RequestChangedEvent;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.es.util.RequestStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class RequestListPresenterTest {
    private static final Long REQUEST_ID = 1L;
    private CallerMock<ExecutorService> callerMockExecutorService;
    @Mock
    private ExecutorService executorServiceMock;
    @Mock
    private RequestListViewImpl viewMock;
    @Mock
    private DataSetQueryHelper dataSetQueryHelper;
    @Spy
    private DataSetLookup dataSetLookup;
    @Mock
    private ExtendedPagedTable<RequestSummary> extendedPagedTable;
    @Mock
    private EventSourceMock<RequestChangedEvent> requestChangedEvent;
    @Mock
    private EventSourceMock<JobSelectedEvent> jobSelectedEventMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private NewJobPresenter newJobPresenterMock;
    @Spy
    private FilterSettings filterSettings;
    private RequestListPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMockExecutorService = new CallerMock((Object)this.executorServiceMock);
        this.filterSettings.setDataSetLookup(this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn(null);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        this.presenter = new RequestListPresenter(this.viewMock, this.callerMockExecutorService, this.dataSetQueryHelper, this.requestChangedEvent, this.jobSelectedEventMock, this.placeManager);
        this.presenter.setNewJobPresenter(this.newJobPresenterMock);
        this.presenter.setServerTemplateSelectorMenuBuilder(new ServerTemplateSelectorMenuBuilder());
    }

    @Test
    public void getDataTest() {
        this.presenter.setAddingDefaultFilters(false);
        this.presenter.getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
    }

    @Test
    public void cancelRequestTest() {
        this.presenter.cancelRequest(null, REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (String)Mockito.eq(null), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void requeueRequestTest() {
        this.presenter.requeueRequest(null, REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (String)Mockito.eq(null), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void cancelRequestTestWithDeploymentId() {
        this.presenter.cancelRequest("test", REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).cancelRequest(Mockito.anyString(), (String)Mockito.eq((Object)"test"), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void requeueRequestTestWithDeploymentId() {
        this.presenter.requeueRequest("test", REQUEST_ID);
        ((EventSourceMock)Mockito.verify(this.requestChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RequestChangedEvent.class));
        ((ExecutorService)Mockito.verify((Object)this.executorServiceMock)).requeueRequest(Mockito.anyString(), (String)Mockito.eq((Object)"test"), (Long)Mockito.eq((Object)REQUEST_ID));
    }

    @Test
    public void testGetRequestSummary() {
        Long id = 1L;
        String message = "message";
        String status = "DONE";
        String commandName = "commandName";
        String businessKey = "businessKey";
        Integer retries = 2;
        Integer executions = 1;
        Date time = new Date();
        String processName = "myProcessName";
        Long processInstanceId = 33L;
        String processInstanceDescription = "myProcessInstanceDescription";
        String deploymentId = "test";
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        Mockito.when((Object)dataSet.getValueAt(0, "id")).thenReturn((Object)id);
        Mockito.when((Object)dataSet.getValueAt(0, "timestamp")).thenReturn((Object)time);
        Mockito.when((Object)dataSet.getValueAt(0, "status")).thenReturn((Object)"DONE");
        Mockito.when((Object)dataSet.getValueAt(0, "commandName")).thenReturn((Object)"commandName");
        Mockito.when((Object)dataSet.getValueAt(0, "message")).thenReturn((Object)"message");
        Mockito.when((Object)dataSet.getValueAt(0, "businessKey")).thenReturn((Object)"businessKey");
        Mockito.when((Object)dataSet.getValueAt(0, "retries")).thenReturn((Object)retries);
        Mockito.when((Object)dataSet.getValueAt(0, "executions")).thenReturn((Object)executions);
        Mockito.when((Object)dataSet.getValueAt(0, "processName")).thenReturn((Object)"myProcessName");
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceId")).thenReturn((Object)processInstanceId);
        Mockito.when((Object)dataSet.getValueAt(0, "processInstanceDescription")).thenReturn((Object)"myProcessInstanceDescription");
        Mockito.when((Object)dataSet.getValueAt(0, "deploymentId")).thenReturn((Object)"test");
        RequestSummary rs = this.presenter.getRequestSummary(dataSet, Integer.valueOf(0));
        Assert.assertEquals((Object)id, (Object)rs.getId());
        Assert.assertEquals((Object)time, (Object)rs.getTime());
        Assert.assertEquals((Object)RequestStatus.DONE, (Object)rs.getStatus());
        Assert.assertEquals((Object)"commandName", (Object)rs.getCommandName());
        Assert.assertEquals((Object)"message", (Object)rs.getMessage());
        Assert.assertEquals((Object)"businessKey", (Object)rs.getKey());
        Assert.assertEquals((Object)retries, (Object)rs.getRetries());
        Assert.assertEquals((Object)executions, (Object)rs.getExecutions());
        Assert.assertEquals((Object)"myProcessName", (Object)rs.getProcessName());
        Assert.assertEquals((Object)processInstanceId, (Object)rs.getProcessInstanceId());
        Assert.assertEquals((Object)"myProcessInstanceDescription", (Object)rs.getProcessInstanceDescription());
        Assert.assertEquals((Object)"test", (Object)rs.getDeploymentId());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.presenter.setupDefaultActiveSearchFilters();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Status()), (String)Mockito.eq((Object)Constants.INSTANCE.Running()), Mockito.eq((Object)RequestStatus.RUNNING.name()), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        this.presenter.onStartup(place);
        this.presenter.setupActiveSearchFilters();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Mockito.eq((Object)Constants.INSTANCE.Status()), (String)Mockito.eq((Object)Constants.INSTANCE.Running()), Mockito.eq((Object)RequestStatus.RUNNING.name()), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testStatusActionConditionPredicates() {
        RequestStatus[] CANCEL_ALLOW_STATUSES = new RequestStatus[]{RequestStatus.QUEUED, RequestStatus.RETRYING, RequestStatus.RUNNING};
        RequestStatus[] REQUEUE_ALLOW_STATUSES = new RequestStatus[]{RequestStatus.ERROR, RequestStatus.RUNNING};
        RequestSummary testJob = new RequestSummary();
        for (RequestStatus status : RequestStatus.values()) {
            testJob.setStatus(status);
            Assert.assertEquals((Object)Arrays.asList(CANCEL_ALLOW_STATUSES).contains(status), (Object)this.presenter.getCancelActionCondition().test(testJob));
            Assert.assertEquals((Object)Arrays.asList(REQUEUE_ALLOW_STATUSES).contains(status), (Object)this.presenter.getRequeueActionCondition().test(testJob));
        }
    }

    @Test
    public void testViewProcessActionConditionPredicates() {
        RequestSummary testJob = new RequestSummary();
        testJob.setProcessInstanceId(Long.valueOf(33L));
        Assert.assertTrue((boolean)this.presenter.getViewProcessActionCondition().test(testJob));
        testJob.setProcessInstanceId(null);
        Assert.assertFalse((boolean)this.presenter.getViewProcessActionCondition().test(testJob));
        Assert.assertFalse((boolean)this.presenter.getViewProcessActionCondition().test(new RequestSummary()));
    }

    @Test
    public void testJobSelectionWithDetailsClosed() {
        RequestSummary job = JobUtils.createRequestSummary();
        boolean closed = true;
        Mockito.when((Object)this.placeManager.getStatus((PlaceRequest)Mockito.any(DefaultPlaceRequest.class))).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.selectJob(job, Boolean.valueOf(closed));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("JobDetailsScreen");
        ArgumentCaptor captor = ArgumentCaptor.forClass(JobSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.jobSelectedEventMock)).fire(captor.capture());
        this.assertJobSelectedEventContent((JobSelectedEvent)captor.getValue(), job.getDeploymentId(), (Long)job.getId());
    }

    @Test
    public void testJobSelectionWithDetailsOpen() {
        RequestSummary job = JobUtils.createRequestSummary();
        boolean closed = false;
        Mockito.when((Object)this.placeManager.getStatus((PlaceRequest)Mockito.any(DefaultPlaceRequest.class))).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.selectJob(job, Boolean.valueOf(closed));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(JobSelectedEvent.class);
        ((EventSourceMock)Mockito.verify(this.jobSelectedEventMock)).fire(captor.capture());
        this.assertJobSelectedEventContent((JobSelectedEvent)captor.getValue(), job.getDeploymentId(), (Long)job.getId());
    }

    @Test
    public void testCloseDetails() {
        RequestSummary job = JobUtils.createRequestSummary();
        boolean closed = true;
        Mockito.when((Object)this.placeManager.getStatus((PlaceRequest)Mockito.any(DefaultPlaceRequest.class))).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.selectJob(job, Boolean.valueOf(closed));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo(Mockito.anyString());
        ((EventSourceMock)Mockito.verify(this.jobSelectedEventMock, (VerificationMode)Mockito.never())).fire(Mockito.any());
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace("JobDetailsScreen");
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateNull() {
        this.presenter.setSelectedServerTemplate(null);
        this.presenter.getMenus();
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification("SelectServerTemplate");
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock, (VerificationMode)Mockito.never())).openNewJobDialog(Mockito.anyString());
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateEmpty() {
        Assert.assertTrue((boolean)this.presenter.getSelectedServerTemplate().isEmpty());
        this.presenter.getMenus();
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification("SelectServerTemplate");
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock, (VerificationMode)Mockito.never())).openNewJobDialog(Mockito.anyString());
    }

    @Test
    public void testOpenNewJobDialog_serverTemplateSet() {
        String serverTemplateTest = "serverTemplateTest";
        this.presenter.setSelectedServerTemplate("serverTemplateTest");
        Menus menus = this.presenter.getMenus();
        MenuItem newJobItem = (MenuItem)menus.getItems().get(0);
        Assert.assertEquals((Object)"New_Job", (Object)newJobItem.getCaption());
        Assert.assertTrue((boolean)newJobItem.isEnabled());
        Assert.assertNotNull((Object)this.presenter.getNewJobCommand());
        this.presenter.getNewJobCommand().execute();
        Assert.assertTrue((boolean)"serverTemplateTest".equals(this.presenter.getSelectedServerTemplate()));
        ((NewJobPresenter)Mockito.verify((Object)this.newJobPresenterMock)).openNewJobDialog("serverTemplateTest");
        ((RequestListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)3))).getListGrid();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.viewMock});
    }

    private void assertJobSelectedEventContent(JobSelectedEvent event, String deploymentId, Long jobId) {
        Assert.assertEquals((Object)jobId, (Object)event.getJobId());
        Assert.assertEquals((Object)deploymentId, (Object)event.getDeploymentId());
    }
}

